/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import wanion.lib.module.AbstractModule;
import wanion.unidict.UniDict;
import wanion.unidict.common.Reference;
import wanion.unidict.integration.AE2Integration;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.integration.AbyssalCraftIntegration;
import wanion.unidict.integration.AdvancedRocketryIntegration;
import wanion.unidict.integration.BaseMetalsIntegration;
import wanion.unidict.integration.CraftingIntegration;
import wanion.unidict.integration.EmbersIntegration;
import wanion.unidict.integration.ExtremeEnergyIntegration;
import wanion.unidict.integration.ForestryIntegration;
import wanion.unidict.integration.ForgeCraftIntegration;
import wanion.unidict.integration.FurnaceIntegration;
import wanion.unidict.integration.IC2Integration;
import wanion.unidict.integration.IEIntegration;
import wanion.unidict.integration.IndustrialForegoingIntegration;
import wanion.unidict.integration.MagnetiCraftIntegration;
import wanion.unidict.integration.MekanismIntegration;
import wanion.unidict.integration.TEIntegration;
import wanion.unidict.integration.TechRebornIntegration;

public final class IntegrationModule
extends AbstractModule
implements UniDict.IDependency {
    private final Set<Class<AbstractIntegrationThread>> MOD_INTEGRATIONS = new LinkedHashSet<Class<AbstractIntegrationThread>>();

    public IntegrationModule() {
        super("Integration", Class::newInstance);
    }

    public static IntegrationModule getIntegrationModule() {
        return (IntegrationModule)UniDict.getDependencies().get(IntegrationModule.class);
    }

    public void registerIntegration(@Nonnull Class<AbstractIntegrationThread> integrationClassToRegister) {
        if (!this.MOD_INTEGRATIONS.contains(integrationClassToRegister)) {
            this.MOD_INTEGRATIONS.add(integrationClassToRegister);
        }
    }

    protected void init() {
        Configuration config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "IntegrationModule.cfg"));
        for (Integration integration : Integration.values()) {
            if (!config.get("Integrations", WordUtils.capitalizeFully((String)integration.name().replace("_", " ")).replace(" ", ""), integration.enabledByDefault).getBoolean() || integration.modId != null && !Loader.isModLoaded((String)integration.modId)) continue;
            this.manager.add(integration.integrationClass);
        }
        this.MOD_INTEGRATIONS.forEach(arg_0 -> ((AbstractModule.Manager)this.manager).add(arg_0));
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static enum Integration {
        CRAFTING(CraftingIntegration.class),
        FURNACE(FurnaceIntegration.class),
        ABYSSAL_CRAFT("abyssalcraft", AbyssalCraftIntegration.class),
        ADVANCED_ROCKETRY("advancedrocketry", AdvancedRocketryIntegration.class),
        APPLIED_ENERGISTICS_2("appliedenergistics2", AE2Integration.class),
        BASE_METALS("basemetals", BaseMetalsIntegration.class),
        EMBERS("embers", EmbersIntegration.class),
        EXTREME_ENERGY("meem", ExtremeEnergyIntegration.class),
        FORESTRY("forestry", ForestryIntegration.class),
        FORGE_CRAFT("forgecraft", ForgeCraftIntegration.class),
        IMMERSIVE_ENGINEERING("immersiveengineering", IEIntegration.class),
        INDUSTRIAL_CRAFT_2("ic2", IC2Integration.class),
        IDUSTRIAL_FOREGOIN("industrialforegoing", IndustrialForegoingIntegration.class),
        MAGNETICRAFT("magneticraft", MagnetiCraftIntegration.class),
        MEKANISM("mekanism", MekanismIntegration.class),
        TECH_REBORN("techreborn", TechRebornIntegration.class),
        THERMAL_EXPANSION("thermalexpansion", TEIntegration.class);

        private final String modId;
        private final Class<? extends AbstractIntegrationThread> integrationClass;
        private final boolean enabledByDefault;

        private Integration(Class<? extends AbstractIntegrationThread> integrationClass) {
            this(null, integrationClass);
        }

        private Integration(String modId, Class<? extends AbstractIntegrationThread> integrationClass) {
            this.modId = modId;
            this.integrationClass = integrationClass;
            this.enabledByDefault = true;
        }

        private Integration(String modId, Class<? extends AbstractIntegrationThread> integrationClass, boolean enabledByDefault) {
            this.modId = modId;
            this.integrationClass = integrationClass;
            this.enabledByDefault = enabledByDefault;
        }
    }
}

