/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.plugin.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import wanion.lib.recipe.RecipeAttributes;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.UniDict;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.plugin.crafttweaker.RemovalByKind.Crafting;
import wanion.unidict.plugin.crafttweaker.RemovalByKind.Furnace;
import wanion.unidict.plugin.crafttweaker.RemovalByKind.RemovalByKind;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.UniResourceContainer;

@ZenRegister
@ZenClass(value="mods.unidict.api")
public final class UniDictCraftTweakerPlugin {
    private static final List<ShapedRecipeTemplate> NEW_SHAPED_RECIPE_TEMPLATE_LIST = new ArrayList<ShapedRecipeTemplate>();
    private static final List<ShapelessRecipeTemplate> NEW_SHAPELESS_RECIPE_TEMPLATE_LIST = new ArrayList<ShapelessRecipeTemplate>();
    private static final Map<Class<? extends RemovalByKind>, RemovalByKind> REMOVAL_BY_KIND_MAP = new HashMap<Class<? extends RemovalByKind>, RemovalByKind>();
    public static final Map<String, RemovalByKind> NAME_REMOVAL_BY_KIND_MAP = new HashMap<String, RemovalByKind>();

    private UniDictCraftTweakerPlugin() {
    }

    @ZenMethod
    public static void newShapedRecipeTemplate(@Nonnull String outputKind, int outputSize, @Nonnull String[][] inputKinds) {
        CraftTweakerAPI.apply((IAction)new ShapedRecipeTemplate(outputKind, outputSize, inputKinds));
    }

    @ZenMethod
    public static void newShapelessRecipeTemplate(@Nonnull String outputKind, int outputSize, @Nonnull String[] inputKinds) {
        CraftTweakerAPI.apply((IAction)new ShapelessRecipeTemplate(outputKind, outputSize, inputKinds));
    }

    public static void preInit() {
        UniDictCraftTweakerPlugin.registerAbstractRemovalByKind(new Crafting());
        UniDictCraftTweakerPlugin.registerAbstractRemovalByKind(new Furnace());
    }

    private static void registerAbstractRemovalByKind(@Nonnull RemovalByKind removalByKind) {
        REMOVAL_BY_KIND_MAP.put(removalByKind.getClass(), removalByKind);
        NAME_REMOVAL_BY_KIND_MAP.put(removalByKind.toString(), removalByKind);
    }

    public static <R extends RemovalByKind> R getRemovalByKind(@Nonnull Class<R> abstractRemovalByKindClass) {
        return (R)((RemovalByKind)abstractRemovalByKindClass.cast(REMOVAL_BY_KIND_MAP.get(abstractRemovalByKindClass)));
    }

    public static void init() {
        UniDictAPI uniDictAPI;
        UniDictAPI uniDictAPI2 = uniDictAPI = REMOVAL_BY_KIND_MAP.size() > 0 || NEW_SHAPED_RECIPE_TEMPLATE_LIST.size() > 0 || NEW_SHAPELESS_RECIPE_TEMPLATE_LIST.size() > 0 ? UniDict.getAPI() : null;
        if (uniDictAPI == null) {
            return;
        }
        REMOVAL_BY_KIND_MAP.values().forEach(removalByKind -> removalByKind.apply(uniDictAPI));
        ArrayList<IRecipe> recipeList = new ArrayList<IRecipe>();
        UniDictCraftTweakerPlugin.fetchShapedRecipeTemplates(uniDictAPI, recipeList);
        UniDictCraftTweakerPlugin.fetchShapelessRecipeTemplates(uniDictAPI, recipeList);
        IForgeRegistry recipeRegistry = ForgeRegistries.RECIPES;
        recipeList.forEach(recipe -> recipeRegistry.register((IForgeRegistryEntry)recipe.setRegistryName(new ResourceLocation(recipe.func_193358_e()))));
    }

    private static void fetchShapedRecipeTemplates(@Nonnull UniDictAPI uniDictAPI, @Nonnull List<IRecipe> recipeList) {
        NEW_SHAPED_RECIPE_TEMPLATE_LIST.forEach(shapedRecipeTemplate -> {
            boolean badEntry = false;
            if (Resource.getKindFromName(((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind) == 0) {
                badEntry = true;
            }
            String[][] stringArray = ((ShapedRecipeTemplate)shapedRecipeTemplate).inputs;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] subInputs;
                for (String input : subInputs = stringArray[i]) {
                    if (input.isEmpty() || !((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind.equals(input) && Resource.getKindFromName(input) != 0) continue;
                    badEntry = true;
                }
            }
            if (!badEntry) {
                TObjectIntHashMap nameKindMap = new TObjectIntHashMap();
                nameKindMap.put((Object)((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind, Resource.getKindFromName(((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind));
                Object[] trueInputs = new String[9];
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        if (y * 3 + x >= trueInputs.length) continue;
                        trueInputs[y * 3 + x] = !((ShapedRecipeTemplate)shapedRecipeTemplate).inputs[x][y].equals("") ? ((ShapedRecipeTemplate)shapedRecipeTemplate).inputs[x][y] : null;
                    }
                }
                for (Object input : trueInputs) {
                    if (input == null || nameKindMap.containsKey(input)) continue;
                    nameKindMap.put(input, Resource.getKindFromName((String)input));
                }
                RecipeAttributes recipeAttributes = RecipeHelper.rawShapeToShape((Object[])trueInputs);
                int outputKind = Resource.getKindFromName(((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind);
                List<Resource> resourceList = uniDictAPI.getResources(nameKindMap.values());
                resourceList.forEach(resource -> {
                    UniResourceContainer uniResourceContainer = resource.getChild(outputKind);
                    ItemStack itemStack = uniResourceContainer.getMainEntry();
                    int stackSize = MathHelper.func_76125_a((int)((ShapedRecipeTemplate)shapedRecipeTemplate).outputSize, (int)1, (int)itemStack.func_77976_d());
                    itemStack.func_190920_e(stackSize);
                    recipeList.add((IRecipe)new ShapedOreRecipe(new ResourceLocation("unidict", uniResourceContainer.name + ".x" + stackSize + "_shape." + recipeAttributes.shape + ".template"), itemStack, UniDictCraftTweakerPlugin.kindShapeToActualShape(recipeAttributes.actualShape, resource)));
                });
            }
        });
    }

    private static void fetchShapelessRecipeTemplates(@Nonnull UniDictAPI uniDictAPI, @Nonnull List<IRecipe> recipeList) {
        NEW_SHAPELESS_RECIPE_TEMPLATE_LIST.forEach(shapelessRecipeTemplate -> {
            boolean badEntry = false;
            if (Resource.getKindFromName(((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind) == 0) {
                badEntry = true;
            }
            for (String input : ((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs) {
                if (input.isEmpty() || !((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind.equals(input) && Resource.getKindFromName(input) != 0) continue;
                badEntry = true;
            }
            if (!badEntry) {
                TObjectIntHashMap nameKindMap = new TObjectIntHashMap();
                nameKindMap.put((Object)((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind, Resource.getKindFromName(((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind));
                for (String input : ((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs) {
                    if (nameKindMap.containsKey((Object)input)) continue;
                    nameKindMap.put((Object)input, Resource.getKindFromName(input));
                }
                int outputKind = Resource.getKindFromName(((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind);
                List<Resource> resourceList = uniDictAPI.getResources(nameKindMap.values());
                resourceList.forEach(resource -> {
                    UniResourceContainer uniResourceContainer = resource.getChild(outputKind);
                    ItemStack itemStack = uniResourceContainer.getMainEntry();
                    int stackSize = MathHelper.func_76125_a((int)((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputSize, (int)1, (int)itemStack.func_77976_d());
                    itemStack.func_190920_e(stackSize);
                    recipeList.add((IRecipe)new ShapelessOreRecipe(new ResourceLocation("unidict", uniResourceContainer.name + ".x" + ((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputSize + "_size." + ((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs.length + ".template"), itemStack, UniDictCraftTweakerPlugin.kindShapeToActualShape(((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs, resource)));
                });
            }
        });
    }

    private static Object[] kindShapeToActualShape(@Nonnull Object[] inputs, @Nonnull Resource resource) {
        Object[] newInputKinds = new Object[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            int kind;
            Object input = inputs[i];
            newInputKinds[i] = input instanceof String && (kind = Resource.getKindFromName((String)input)) != 0 ? resource.getChild((int)kind).name : input;
        }
        return newInputKinds;
    }

    private static class ShapelessRecipeTemplate
    implements IAction {
        private final String outputKind;
        private final int outputSize;
        private final String[] inputs;

        private ShapelessRecipeTemplate(@Nonnull String output, int outputSize, @Nonnull String[] inputs) {
            this.outputKind = output;
            this.outputSize = outputSize;
            this.inputs = inputs;
        }

        public void apply() {
            NEW_SHAPELESS_RECIPE_TEMPLATE_LIST.add(this);
        }

        public String describe() {
            return "Trying to create a Shapeless Recipe Template for kind: " + this.outputKind;
        }
    }

    private static class ShapedRecipeTemplate
    implements IAction {
        private final String outputKind;
        private final int outputSize;
        private final String[][] inputs;

        private ShapedRecipeTemplate(@Nonnull String outputKind, int outputSize, @Nonnull String[][] inputs) {
            this.outputKind = outputKind;
            this.outputSize = outputSize;
            this.inputs = inputs;
            for (String[] subInputs : inputs) {
                for (int i = 0; i < subInputs.length; ++i) {
                    if (subInputs[i] != null) continue;
                    subInputs[i] = "";
                }
            }
        }

        public void apply() {
            NEW_SHAPED_RECIPE_TEMPLATE_LIST.add(this);
        }

        public String describe() {
            return "Trying to create a Shaped Recipe Template for kind: " + this.outputKind;
        }
    }
}

