/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import wanion.lib.common.MetaItem;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.UniAttributes;
import wanion.unidict.resource.UniResourceContainer;

public final class ResourceHandler
implements UniDict.IDependency {
    static final Set<ItemStack> keepOneEntryBlackSet = new HashSet<ItemStack>();
    public final Collection<Resource> resources;
    private final TIntObjectMap<UniAttributes> individualStackAttributes = new TIntObjectHashMap();
    private final Map<String, Resource> resourceMap;
    private FMLStateEvent event = null;

    public ResourceHandler(@Nonnull Map<String, Resource> resourceMap) {
        this.resourceMap = resourceMap;
        this.resources = this.resourceMap.values();
    }

    public static void addToKeepOneEntryModBlackSet(@Nonnull ItemStack itemStack) {
        keepOneEntryBlackSet.add(itemStack);
    }

    public boolean exists(int thingId) {
        return this.individualStackAttributes.containsKey(thingId);
    }

    public boolean exists(ItemStack thing) {
        return this.individualStackAttributes.containsKey(MetaItem.get((ItemStack)thing));
    }

    public boolean resourceExists(@Nonnull String name) {
        return this.resourceMap.containsKey(name);
    }

    public UniAttributes get(ItemStack thing) {
        int hash = MetaItem.get((ItemStack)thing);
        return (UniAttributes)this.individualStackAttributes.get(hash);
    }

    public Resource getResource(String resourceName) {
        return this.resourceMap.get(resourceName);
    }

    public Resource getResource(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.resource : null;
    }

    public UniResourceContainer getContainer(@Nonnull String resource, @Nonnull String child) {
        return this.containerExists(resource, child) ? this.resourceMap.get(resource).getChild(Resource.getKindFromName(child)) : null;
    }

    public UniResourceContainer getContainer(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.uniResourceContainer : null;
    }

    public String getContainerName(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.uniResourceContainer.name : null;
    }

    public ItemStack getMainItemStack(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.uniResourceContainer.getMainEntry(thing) : thing;
    }

    public List<ItemStack> getMainItemStacks(@Nonnull Collection<ItemStack> things) {
        return things.stream().map(this::getMainItemStack).collect(Collectors.toList());
    }

    public int getKind(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.uniResourceContainer.kind : 0;
    }

    public void setMainItemStacks(@Nonnull List<ItemStack> thingList) {
        for (int i = 0; i < thingList.size(); ++i) {
            thingList.set(i, this.getMainItemStack(thingList.get(i)));
        }
    }

    public void setMainObjects(@Nonnull List<Object> thingList) {
        for (int i = 0; i < thingList.size(); ++i) {
            if (!(thingList.get(i) instanceof ItemStack)) continue;
            thingList.set(i, this.getMainItemStack((ItemStack)thingList.get(i)));
        }
    }

    public ItemStack[] getMainItemStacks(@Nonnull ItemStack[] things) {
        for (int i = 0; i < things.length; ++i) {
            things[i] = this.getMainItemStack(things[i]);
        }
        return things;
    }

    public void setMainItemStacks(@Nonnull Object[] things) {
        for (int i = 0; i < things.length; ++i) {
            if (!(things[i] instanceof ItemStack)) continue;
            things[i] = this.getMainItemStack((ItemStack)things[i]);
        }
    }

    public boolean containerExists(@Nonnull String resource, @Nonnull String child) {
        return this.resourceMap.containsKey(resource) && this.resourceMap.get(resource).childExists(Resource.getKindFromName(child));
    }

    public List<Resource> getResources(int ... kinds) {
        return Resource.getResources(this.resources, kinds);
    }

    public void populateIndividualStackAttributes(FMLStateEvent event) {
        if (this.event == null || this.event != event) {
            this.event = event;
            this.populateIndividualStackAttributes();
        }
    }

    public void populateIndividualStackAttributes() {
        this.individualStackAttributes.clear();
        TIntHashSet itemStackToIgnoreHashSet = new TIntHashSet();
        Config config = UniDict.getConfig();
        config.itemStacksNamesToIgnore.forEach(arg_0 -> ResourceHandler.lambda$populateIndividualStackAttributes$0((TIntSet)itemStackToIgnoreHashSet, arg_0));
        config.itemStacksToIgnore.forEach(arg_0 -> ResourceHandler.lambda$populateIndividualStackAttributes$1((TIntSet)itemStackToIgnoreHashSet, arg_0));
        this.resources.forEach(arg_0 -> this.lambda$populateIndividualStackAttributes$3((TIntSet)itemStackToIgnoreHashSet, arg_0));
    }

    private /* synthetic */ void lambda$populateIndividualStackAttributes$3(TIntSet itemStackToIgnoreHashSet, Resource resource) {
        resource.getChildrenMap().forEachValue(container -> {
            UniAttributes uniAttributes = new UniAttributes(resource, (UniResourceContainer)container);
            for (int hash : container.getHashes()) {
                if (itemStackToIgnoreHashSet.contains(hash)) continue;
                this.individualStackAttributes.put(hash, (Object)uniAttributes);
            }
            return true;
        });
    }

    private static /* synthetic */ void lambda$populateIndividualStackAttributes$1(TIntSet itemStackToIgnoreHashSet, ItemStack itemStack) {
        itemStackToIgnoreHashSet.add(MetaItem.get((ItemStack)itemStack));
    }

    private static /* synthetic */ void lambda$populateIndividualStackAttributes$0(TIntSet itemStackToIgnoreHashSet, String itemName) {
        int separatorChar = itemName.indexOf(35);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(separatorChar == -1 ? itemName : itemName.substring(0, separatorChar)));
        if (item != null) {
            int metaData = separatorChar == -1 ? 0 : Integer.parseInt(itemName.substring(separatorChar + 1, itemName.length()));
            itemStackToIgnoreHashSet.add(MetaItem.get((ItemStack)new ItemStack(item, 1, metaData)));
        }
    }
}

