/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mcmultipart.MCMPCommonProxy;
import mcmultipart.api.addon.IMCMPAddon;
import mcmultipart.api.addon.MCMPAddon;
import mcmultipart.api.microblock.MicroMaterial;
import mcmultipart.api.microblock.MicroblockType;
import mcmultipart.api.multipart.MultipartCapabilityHelper;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.EnumCornerSlot;
import mcmultipart.api.slot.EnumEdgeSlot;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.slot.ISlottedContainer;
import mcmultipart.api.slot.SlotUtil;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.capability.CapabilityJoiner;
import mcmultipart.capability.CapabilityMultipartContainer;
import mcmultipart.capability.CapabilityMultipartTile;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.network.MultipartNetworkHandler;
import mcmultipart.slot.SlotRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.Logger;

@Mod(modid="mcmultipart", name="MCMultiPart", version="2.4.1", acceptedMinecraftVersions="[1.12,)")
public class MCMultiPart {
    public static final String MODID = "mcmultipart";
    public static final String NAME = "MCMultiPart";
    public static final String VERSION = "2.4.1";
    @SidedProxy(serverSide="mcmultipart.MCMPCommonProxy", clientSide="mcmultipart.client.MCMPClientProxy")
    public static MCMPCommonProxy proxy;
    public static Logger log;
    public static Block multipart;
    public static ForgeRegistry<IPartSlot> slotRegistry;
    public static ForgeRegistry<MicroMaterial> microMaterialRegistry;
    public static ForgeRegistry<MicroblockType> microblockTypeRegistry;
    public static ObjectIntIdentityMap<IBlockState> stateMap;
    private final List<IMCMPAddon> addons = new ArrayList<IMCMPAddon>();

    public MCMultiPart() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRegistrySetup(RegistryEvent.NewRegistry event) {
        slotRegistry = (ForgeRegistry)new RegistryBuilder().setName(new ResourceLocation(MODID, "slots")).setIDRange(0, Short.MAX_VALUE).setType(IPartSlot.class).create();
        microMaterialRegistry = (ForgeRegistry)new RegistryBuilder().setName(new ResourceLocation(MODID, "micro_material")).setIDRange(0, Short.MAX_VALUE).setType(MicroMaterial.class).create();
        microblockTypeRegistry = (ForgeRegistry)new RegistryBuilder().setName(new ResourceLocation(MODID, "micro_type")).setIDRange(0, Short.MAX_VALUE).setType(MicroblockType.class).create();
    }

    @SubscribeEvent
    public void onSlotRegistryInit(RegistryEvent.Register<IPartSlot> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])EnumFaceSlot.VALUES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])EnumEdgeSlot.VALUES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])EnumCornerSlot.VALUES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IPartSlot[]{EnumCenterSlot.CENTER});
    }

    @SubscribeEvent
    public void onBlockRegistryInit(RegistryEvent.Register<Block> event) {
        multipart = new BlockMultipartContainer();
        event.getRegistry().register(multipart.setRegistryName("multipart"));
        GameRegistry.registerTileEntity(TileMultipartContainer.class, (String)"mcmultipart:multipart.nonticking");
        GameRegistry.registerTileEntity(TileMultipartContainer.Ticking.class, (String)"mcmultipart:multipart.ticking");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            this.initAPI();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        log = event.getModLog();
        stateMap = GameData.getBlockStateIDMap();
        CapabilityMultipartContainer.register();
        CapabilityMultipartTile.register();
        MultipartCapabilityHelper.registerCapabilityJoiner(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, CapabilityJoiner.JoinedItemHandler::join);
        MultipartNetworkHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        proxy.preInit();
        event.getAsmData().getAll(MCMPAddon.class.getName()).forEach(a -> {
            try {
                Class<?> addon = Class.forName(a.getClassName());
                if (IMCMPAddon.class.isAssignableFrom(addon)) {
                    this.addons.add((IMCMPAddon)addon.newInstance());
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.addons.forEach(a -> a.registerParts(MultipartRegistry.INSTANCE));
        MultipartRegistry.INSTANCE.computeBlocks();
        SlotRegistry.INSTANCE.computeAccess();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public <T> void initAPI() throws Exception {
        ReflectionHelper.setPrivateValue(MultipartHelper.class, null, TileMultipartContainer::createTileFromWorldInfo, (String[])new String[]{"createTileFromWorldInfo"});
        ReflectionHelper.setPrivateValue(MultipartHelper.class, null, TileMultipartContainer::createTile, (String[])new String[]{"createTile"});
        ReflectionHelper.setPrivateValue(MultipartHelper.class, null, MultipartRegistry.INSTANCE::getPart, (String[])new String[]{"getPart"});
        ReflectionHelper.setPrivateValue(MultipartCapabilityHelper.class, null, CapabilityJoiner::registerCapabilityJoiner, (String[])new String[]{"registerJoiner"});
        MethodHandle viewSide = MethodHandles.lookup().unreflect(SlotRegistry.class.getMethod("viewContainer", ISlottedContainer.class, Function.class, Function.class, Object.class, Boolean.TYPE, EnumFacing.class)).bindTo((Object)SlotRegistry.INSTANCE);
        MethodHandle viewEdge = MethodHandles.lookup().unreflect(SlotRegistry.class.getMethod("viewContainer", ISlottedContainer.class, Function.class, Function.class, Object.class, Boolean.TYPE, EnumEdgeSlot.class, EnumFacing.class)).bindTo((Object)SlotRegistry.INSTANCE);
        ReflectionHelper.setPrivateValue(SlotUtil.class, null, (Object)viewSide, (String[])new String[]{"viewSide"});
        ReflectionHelper.setPrivateValue(SlotUtil.class, null, (Object)viewEdge, (String[])new String[]{"viewEdge"});
    }
}

