/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.multipart;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartCapabilityHelper;
import mcmultipart.api.multipart.MultipartOcclusionHelper;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IWorldView;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public interface IMultipart {
    default public Block getBlock() {
        if (!(this instanceof Block)) {
            throw new IllegalStateException("This multipart isn't a Block. Override IMultipart#getBlock()!");
        }
        return (Block)this;
    }

    default public boolean shouldWrapWorld() {
        return true;
    }

    default public IWorldView getWorldView(IPartInfo part) {
        return IWorldView.getDefaultFor(part);
    }

    default public IMultipartTile convertToMultipartTile(TileEntity tileEntity) {
        return MultipartCapabilityHelper.optional(tileEntity, MCMPCapabilities.MULTIPART_TILE, null).orElseThrow(() -> new IllegalStateException("The block " + this.getBlock().getRegistryName() + " is multipart-compatible but its TileEntity isn't!"));
    }

    default public IMultipartTile createMultipartTile(World world, IPartSlot slot, IBlockState state) {
        TileEntity tileEntity = state.func_177230_c().createTileEntity(world, state);
        return tileEntity != null ? this.convertToMultipartTile(tileEntity) : null;
    }

    default public IMultipartTile loadMultipartTile(World world, NBTTagCompound tag) {
        return this.convertToMultipartTile(TileEntity.func_190200_a((World)world, (NBTTagCompound)tag));
    }

    public IPartSlot getSlotForPlacement(World var1, BlockPos var2, IBlockState var3, EnumFacing var4, float var5, float var6, float var7, EntityLivingBase var8);

    public IPartSlot getSlotFromWorld(IBlockAccess var1, BlockPos var2, IBlockState var3);

    default public Set<IPartSlot> getGhostSlots(IPartInfo part) {
        return Collections.emptySet();
    }

    default public List<AxisAlignedBB> getOcclusionBoxes(IPartInfo part) {
        return Collections.singletonList(part.getState().func_185900_c((IBlockAccess)part.getPartWorld(), part.getPartPos()));
    }

    default public boolean testIntersection(IPartInfo self, IPartInfo otherPart) {
        return MultipartOcclusionHelper.testBoxIntersection(this.getOcclusionBoxes(self), otherPart.getPart().getOcclusionBoxes(otherPart));
    }

    default public RayTraceResult collisionRayTrace(IPartInfo part, Vec3d start, Vec3d end) {
        return part.getState().func_185910_a(part.getPartWorld(), part.getPartPos(), start, end);
    }

    default public IBlockState getActualState(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().func_185899_b(world, pos);
    }

    default public IBlockState getExtendedState(IBlockAccess world, BlockPos pos, IPartInfo part, IBlockState state) {
        return state.func_177230_c().getExtendedState(state, world, pos);
    }

    default public boolean canRenderInLayer(IBlockAccess world, BlockPos pos, IPartInfo part, IBlockState state, BlockRenderLayer layer) {
        return state.func_177230_c().canRenderInLayer(state, layer);
    }

    default public void onPartPlacedBy(IPartInfo part, EntityLivingBase placer, ItemStack stack) {
        part.getState().func_177230_c().func_180633_a(part.getPartWorld(), part.getPartPos(), part.getState(), placer, stack);
    }

    default public boolean isSideSolid(IBlockAccess world, BlockPos pos, IPartInfo part, EnumFacing side) {
        return part.getState().isSideSolid(world, pos, side);
    }

    default public void randomDisplayTick(IPartInfo part, Random rand) {
        part.getState().func_177230_c().func_180655_c(part.getState(), part.getPartWorld(), part.getPartPos(), rand);
    }

    default public boolean addDestroyEffects(IPartInfo part, ParticleManager manager) {
        return part.getState().func_177230_c().addDestroyEffects(part.getPartWorld(), part.getPartPos(), manager);
    }

    default public boolean addHitEffects(IPartInfo part, RayTraceResult hit, ParticleManager manager) {
        return part.getState().func_177230_c().addHitEffects(part.getState(), part.getPartWorld(), hit, manager);
    }

    default public EnumBlockRenderType getRenderType(IPartInfo part) {
        return part.getState().func_185901_i();
    }

    default public AxisAlignedBB getBoundingBox(IPartInfo part) {
        return part.getState().func_185900_c((IBlockAccess)part.getPartWorld(), part.getPartPos());
    }

    default public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, IPartInfo part, EnumFacing side) {
        return part.getState().func_177230_c().canConnectRedstone(part.getState(), world, pos, side);
    }

    default public int getWeakPower(IBlockAccess world, BlockPos pos, IPartInfo part, EnumFacing side) {
        return part.getState().func_185911_a(world, pos, side);
    }

    default public int getStrongPower(IBlockAccess world, BlockPos pos, IPartInfo part, EnumFacing side) {
        return part.getState().func_185893_b(world, pos, side);
    }

    default public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, IPartInfo part, EntityLiving.SpawnPlacementType type) {
        return part.getState().func_177230_c().canCreatureSpawn(part.getState(), world, pos, type);
    }

    default public boolean canSustainLeaves(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().func_177230_c().canSustainLeaves(part.getState(), world, pos);
    }

    default public boolean canSustainPlant(IBlockAccess world, BlockPos pos, IPartInfo part, EnumFacing direction, IPlantable plantable) {
        return part.getState().func_177230_c().canSustainPlant(part.getState(), world, pos, direction, plantable);
    }

    default public void fillWithRain(IPartInfo part) {
        part.getState().func_177230_c().func_176224_k(part.getPartWorld(), part.getPartPos());
    }

    default public int getComparatorInputOverride(IPartInfo part) {
        return part.getState().func_185888_a(part.getPartWorld(), part.getPartPos());
    }

    default public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IPartInfo part, int fortune) {
        return part.getState().func_177230_c().getDrops(world, pos, part.getState(), fortune);
    }

    default public float getExplosionResistance(IPartInfo part, Entity exploder, Explosion explosion) {
        return part.getState().func_177230_c().getExplosionResistance(part.getPartWorld(), part.getPartPos(), exploder, explosion);
    }

    default public float getEnchantPowerBonus(IPartInfo part) {
        return part.getState().func_177230_c().getEnchantPowerBonus(part.getPartWorld(), part.getPartPos());
    }

    default public int getLightOpacity(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().getLightOpacity(world, pos);
    }

    default public int getLightOpacity(IBlockState state) {
        return state.func_185891_c();
    }

    default public int getLightValue(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().getLightValue(world, pos);
    }

    default public int getLightValue(IBlockState state) {
        return state.func_185906_d();
    }

    default public ItemStack getPickPart(IPartInfo part, RayTraceResult hit, EntityPlayer player) {
        return part.getState().func_177230_c().getPickBlock(part.getState(), hit, part.getPartWorld(), part.getPartPos(), player);
    }

    default public float getPlayerRelativePartHardness(IPartInfo part, RayTraceResult hit, EntityPlayer player) {
        return part.getState().func_185903_a(player, part.getPartWorld(), part.getPartPos());
    }

    default public Boolean isAABBInsideMaterial(IPartInfo part, AxisAlignedBB boundingBox, Material material) {
        return part.getState().func_177230_c().isAABBInsideMaterial(part.getPartWorld(), part.getPartPos(), boundingBox, material);
    }

    default public boolean isBeaconBase(IBlockAccess world, BlockPos pos, IPartInfo part, BlockPos beacon) {
        return part.getState().func_177230_c().isBeaconBase(world, pos, beacon);
    }

    default public boolean isBurning(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().func_177230_c().isBurning(world, pos);
    }

    default public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IPartInfo part, Entity entity, double yToTest, Material material, boolean testingHead) {
        return part.getState().func_177230_c().isEntityInsideMaterial(world, pos, part.getState(), entity, yToTest, material, testingHead);
    }

    default public boolean isFertile(IPartInfo part) {
        return part.getState().func_177230_c().isFertile(part.getPartWorld(), part.getPartPos());
    }

    default public boolean isFireSource(IPartInfo part, EnumFacing side) {
        return part.getState().func_177230_c().isFireSource(part.getPartWorld(), part.getPartPos(), side);
    }

    default public boolean isFlammable(IBlockAccess world, BlockPos pos, IPartInfo part, EnumFacing face) {
        return part.getState().func_177230_c().isFlammable(world, pos, face);
    }

    default public boolean isFoliage(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().func_177230_c().isFoliage(world, pos);
    }

    default public boolean isLeaves(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().func_177230_c().isLeaves(part.getState(), world, pos);
    }

    default public boolean isPassable(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().func_177230_c().func_176205_b(world, pos);
    }

    default public boolean isWood(IBlockAccess world, BlockPos pos, IPartInfo part) {
        return part.getState().func_177230_c().isWood(world, pos);
    }

    default public void onPartClicked(IPartInfo part, EntityPlayer player, RayTraceResult hit) {
        part.getState().func_177230_c().func_180649_a(part.getPartWorld(), part.getPartPos(), player);
    }

    default public void neighborChanged(IPartInfo part, Block neighborBlock, BlockPos neighborPos) {
        part.getState().func_189546_a(part.getPartWorld(), part.getPartPos(), neighborBlock, neighborPos);
    }

    default public void onNeighborChange(IPartInfo part, BlockPos neighbor) {
        part.getState().func_177230_c().onNeighborChange((IBlockAccess)part.getPartWorld(), part.getPartPos(), neighbor);
    }

    default public boolean onPartActivated(IPartInfo part, EntityPlayer player, EnumHand hand, RayTraceResult hit) {
        return part.getState().func_177230_c().func_180639_a(part.getPartWorld(), part.getPartPos(), part.getState(), player, hand, hit.field_178784_b, (float)hit.field_72307_f.field_72450_a - (float)hit.func_178782_a().func_177958_n(), (float)hit.field_72307_f.field_72448_b - (float)hit.func_178782_a().func_177956_o(), (float)hit.field_72307_f.field_72449_c - (float)hit.func_178782_a().func_177952_p());
    }

    default public void onPlantGrow(IPartInfo part, BlockPos source) {
        part.getState().func_177230_c().onPlantGrow(part.getState(), part.getPartWorld(), part.getPartPos(), source);
    }

    default public void onPartHarvested(IPartInfo part, EntityPlayer player) {
        part.getState().func_177230_c().func_176208_a(part.getPartWorld(), part.getPartPos(), part.getState(), player);
    }

    default public void randomTick(IPartInfo part, Random random) {
        part.getState().func_177230_c().func_180645_a(part.getPartWorld(), part.getPartPos(), part.getState(), random);
    }

    default public BlockFaceShape getPartFaceShape(IPartInfo part, EnumFacing face) {
        return part.getState().func_193401_d((IBlockAccess)part.getPartWorld(), part.getPartPos(), face);
    }

    default public void onAdded(IPartInfo part) {
    }

    default public void onRemoved(IPartInfo part) {
    }

    default public boolean canPlacePartAt(World world, BlockPos pos) {
        return this.getBlock().func_176196_c(world, pos);
    }

    default public boolean canPlacePartOnSide(World world, BlockPos pos, EnumFacing side, IPartSlot slot) {
        return this.getBlock().func_176198_a(world, pos, side);
    }

    default public void onPartAdded(IPartInfo part, IPartInfo otherPart) {
        this.onPartChanged(part, otherPart);
    }

    default public void onPartRemoved(IPartInfo part, IPartInfo otherPart) {
        this.onPartChanged(part, otherPart);
    }

    default public void onPartChanged(IPartInfo part, IPartInfo otherPart) {
    }

    default public void breakPart(IPartInfo part) {
        this.getBlock().func_180663_b(part.getPartWorld(), part.getPartPos(), part.getState());
    }

    default public void updateTick(IPartInfo part, Random rand) {
        part.getState().func_177230_c().func_180650_b(part.getPartWorld(), part.getPartPos(), part.getState(), rand);
    }

    default public void addCollisionBoxToList(IPartInfo part, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean unknown) {
        part.getState().func_185908_a(part.getPartWorld(), part.getPartPos(), entityBox, collidingBoxes, entity, unknown);
    }

    default public AxisAlignedBB getCollisionBoundingBox(World world, BlockPos pos, IBlockState state) {
        return state.func_185890_d((IBlockAccess)world, pos);
    }

    default public void onEntityCollidedWithPart(IPartInfo part, Entity entity) {
        part.getState().func_177230_c().func_180634_a(part.getPartWorld(), part.getPartPos(), part.getState(), entity);
    }

    default public void dropPartAsItem(IPartInfo part, int fortune) {
        part.getState().func_177230_c().func_176226_b(part.getActualWorld(), part.getPartPos(), part.getState(), fortune);
    }
}

