/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import mcmultipart.MCMultiPart;
import mcmultipart.RayTraceHelper;
import mcmultipart.api.container.IMultipartContainerBlock;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.slot.SlotUtil;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.multipart.PartInfo;
import mcmultipart.util.PropertyClientInfo;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class BlockMultipartContainer
extends Block
implements ITileEntityProvider,
IMultipartContainerBlock {
    public static final PropertyBool PROPERTY_TICKING = PropertyBool.func_177716_a((String)"ticking");
    public static final PropertyClientInfo PROPERTY_INFO = new PropertyClientInfo();
    private boolean callingLightOpacity = false;
    private boolean callingLightValue = false;

    public BlockMultipartContainer() {
        super(Material.field_151578_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)PROPERTY_TICKING, (Comparable)Boolean.valueOf(true)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return meta == 0 ? new TileMultipartContainer.Ticking() : new TileMultipartContainer();
    }

    public static Optional<TileMultipartContainer> getTile(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te instanceof TileMultipartContainer ? Optional.of((TileMultipartContainer)te) : Optional.empty();
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().isEmpty()).orElse(true);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean unknown) {
        this.forEach((IBlockAccess)world, pos, i -> i.getPart().addCollisionBoxToList((IPartInfo)i, entityBox, collidingBoxes, entity, unknown));
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        Optional<TileMultipartContainer> te = BlockMultipartContainer.getTile((IBlockAccess)world, pos);
        return te.map(t -> t.getParts().values().stream().map(i -> Pair.of((Object)i, (Object)i.getPart().collisionRayTrace((IPartInfo)i, start, end))).filter(p -> p.getValue() != null).min(Comparator.comparingDouble(hit -> ((RayTraceResult)hit.getValue()).field_72307_f.func_72436_e(start))).map(p -> {
            RayTraceResult hit = new RayTraceResult(((RayTraceResult)p.getValue()).field_72307_f, ((RayTraceResult)p.getValue()).field_178784_b, ((RayTraceResult)p.getValue()).func_178782_a());
            hit.hitInfo = p.getValue();
            hit.subHit = MCMultiPart.slotRegistry.getID((IForgeRegistryEntry)((PartInfo)p.getKey()).getSlot());
            return hit;
        }).orElse(null)).orElse(null);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_TICKING, (Comparable)Boolean.valueOf(meta == 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_TICKING) != false ? 0 : 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{PROPERTY_TICKING}).add(new IUnlistedProperty[]{PROPERTY_INFO}).build();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        List info = BlockMultipartContainer.getTile(world, pos).map(c -> c.getParts().values().stream().map(i -> i.getInfo(world, pos)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)PROPERTY_INFO, info);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        Pair<Vec3d, Vec3d> vectors = RayTraceHelper.getRayTraceVectors(player);
        RayTraceResult hit = this.func_180636_a(state, world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        Optional<TileMultipartContainer> tile = BlockMultipartContainer.getTile((IBlockAccess)world, pos);
        if (hit != null && tile.isPresent() && !world.field_72995_K) {
            IPartSlot slot = (IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit);
            tile.get().get(slot).ifPresent(i -> {
                i.getPart().onPartHarvested((IPartInfo)i, player);
                if (player == null || !player.field_71075_bZ.field_75098_d) {
                    i.getPart().getDrops((IBlockAccess)world, pos, (IPartInfo)i, 0).forEach(s -> BlockMultipartContainer.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s));
                }
            });
            tile.get().removePart(slot);
        }
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.anyMatch(world, pos, i -> i.getPart().isSideSolid(i.wrapAsNeeded(world), pos, (IPartInfo)i, side));
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        this.forEach((IBlockAccess)world, pos, i -> i.getPart().randomDisplayTick((IPartInfo)i, rand));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IPartInfo part;
        Pair<Vec3d, Vec3d> vectors = RayTraceHelper.getRayTraceVectors(MCMultiPart.proxy.getPlayer());
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null && !(part = BlockMultipartContainer.getTile((IBlockAccess)world, pos).get().get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).getPart().addDestroyEffects(part, manager)) {
            IBlockState state = part.getPart().getActualState((IBlockAccess)world, pos, part);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        double xOff = ((double)i + 0.5) / 4.0;
                        double yOff = ((double)j + 0.5) / 4.0;
                        double zOff = ((double)k + 0.5) / 4.0;
                        manager.func_78873_a((Particle)new ParticleDigging(world, (double)pos.func_177958_n() + xOff, (double)pos.func_177956_o() + yOff, (double)pos.func_177952_p() + zOff, xOff - 0.5, yOff - 0.5, zOff - 0.5, state){}.func_174846_a(pos));
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState mpState, World world, RayTraceResult hit, ParticleManager manager) {
        BlockPos pos;
        IPartInfo part;
        if (hit != null && !(part = BlockMultipartContainer.getTile((IBlockAccess)world, pos = hit.func_178782_a()).get().get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).getPart().addHitEffects(part, (RayTraceResult)hit.hitInfo, manager) && part.getPart().getRenderType(part) != EnumBlockRenderType.INVISIBLE) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            AxisAlignedBB aabb = part.getPart().getBoundingBox(part);
            double pX = (double)x + world.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - 0.2) + 0.1 + aabb.field_72340_a;
            double pY = (double)y + world.field_73012_v.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - 0.2) + 0.1 + aabb.field_72338_b;
            double pZ = (double)z + world.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - 0.2) + 0.1 + aabb.field_72339_c;
            switch (hit.field_178784_b) {
                case DOWN: {
                    pY = (double)y + aabb.field_72338_b - 0.1;
                    break;
                }
                case UP: {
                    pY = (double)y + aabb.field_72337_e + 0.1;
                    break;
                }
                case NORTH: {
                    pZ = (double)z + aabb.field_72339_c - 0.1;
                    break;
                }
                case SOUTH: {
                    pZ = (double)z + aabb.field_72334_f + 0.1;
                    break;
                }
                case WEST: {
                    pX = (double)x + aabb.field_72340_a - 0.1;
                    break;
                }
                case EAST: {
                    pX = (double)x + aabb.field_72336_d + 0.1;
                }
            }
            manager.func_78873_a(new ParticleDigging(world, pX, pY, pZ, 0.0, 0.0, 0.0, part.getPart().getActualState((IBlockAccess)world, pos, part)){}.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return super.addLandingEffects(state, worldObj, blockPosition, iblockstate, entity, numberOfParticles);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return false;
        }
        return BlockMultipartContainer.getTile(world, pos).map(t -> SlotUtil.viewContainer(t, i -> i.getPart().canConnectRedstone(((PartInfo)i).wrapAsNeeded(world), pos, (IPartInfo)i, side), l -> l.stream().anyMatch(c -> c), false, true, side.func_176734_d())).orElse(false);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        return BlockMultipartContainer.getTile(world, pos).map(t -> SlotUtil.viewContainer(t, i -> i.getPart().getWeakPower(((PartInfo)i).wrapAsNeeded(world), pos, (IPartInfo)i, side), l -> (Integer)l.stream().max(Integer::compare).get(), 0, true, side.func_176734_d())).orElse(0);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        return BlockMultipartContainer.getTile(world, pos).map(t -> SlotUtil.viewContainer(t, i -> i.getPart().getStrongPower(((PartInfo)i).wrapAsNeeded(world), pos, (IPartInfo)i, side), l -> (Integer)l.stream().max(Integer::compare).get(), 0, true, side.func_176734_d())).orElse(0);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return this.anyMatch(world, pos, i -> i.getPart().canCreatureSpawn(i.wrapAsNeeded(world), pos, (IPartInfo)i, type));
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.anyMatch(world, pos, i -> i.getPart().canSustainLeaves(i.wrapAsNeeded(world), pos, (IPartInfo)i));
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.anyMatch(world, pos, i -> i.getPart().canSustainPlant(i.wrapAsNeeded(world), pos, (IPartInfo)i, direction, plantable));
    }

    public void func_176224_k(World world, BlockPos pos) {
        this.forEach((IBlockAccess)world, pos, i -> i.getPart().fillWithRain((IPartInfo)i));
    }

    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return super.getBeaconColorMultiplier(state, world, pos, beaconPos);
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return this.max((IBlockAccess)world, pos, i -> i.getPart().getComparatorInputOverride((IPartInfo)i));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().values().stream().map(i -> i.getPart().getDrops(i.wrapAsNeeded(world), pos, (IPartInfo)i, fortune)).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.addF((IBlockAccess)world, pos, i -> i.getPart().getExplosionResistance((IPartInfo)i, exploder, explosion), Double.POSITIVE_INFINITY);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.addF((IBlockAccess)world, pos, i -> i.getPart().getEnchantPowerBonus((IPartInfo)i), Double.POSITIVE_INFINITY);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return super.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return super.getFlammability(world, pos, face);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.callingLightOpacity) {
            return this.add(world, pos, i -> i.getPart().getLightOpacity(i.getState()), 255);
        }
        this.callingLightOpacity = true;
        int res = this.add(world, pos, i -> i.getPart().getLightOpacity(i.wrapAsNeeded(world), pos, (IPartInfo)i), 255);
        this.callingLightOpacity = false;
        return res;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.callingLightValue) {
            return this.max(world, pos, i -> i.getPart().getLightValue(i.getState()));
        }
        this.callingLightValue = true;
        int res = this.max(world, pos, i -> i.getPart().getLightValue(i.wrapAsNeeded(world), pos, (IPartInfo)i));
        this.callingLightValue = false;
        return res;
    }

    public int func_185484_c(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.func_185484_c(state, world, pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult hit, World world, BlockPos pos, EntityPlayer player) {
        if (hit != null) {
            return BlockMultipartContainer.getTile((IBlockAccess)world, pos).map(t -> t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit))).filter(Optional::isPresent).map(o -> ((IPartInfo)o.get()).getPart().getPickPart((IPartInfo)o.get(), (RayTraceResult)hit.hitInfo, player)).orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        Pair<Vec3d, Vec3d> vectors = RayTraceHelper.getRayTraceVectors(player);
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null) {
            return BlockMultipartContainer.getTile((IBlockAccess)world, pos).map(t -> t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).map(i -> Float.valueOf(i.getPart().getPlayerRelativePartHardness((IPartInfo)i, (RayTraceResult)hit.hitInfo, player))).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return super.getSoundType(state, world, pos, entity);
    }

    public boolean func_149653_t() {
        return true;
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return super.func_149740_M(state);
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB boundingBox, Material material) {
        return BlockMultipartContainer.getTile((IBlockAccess)world, pos).map(t -> t.getParts().values().stream().map(i -> i.getPart().isAABBInsideMaterial((IPartInfo)i, boundingBox, material)).filter(is -> is != null).anyMatch(i -> i)).orElse(false);
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().isEmpty()).orElse(true);
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        return this.anyMatch(world, pos, i -> i.getPart().isBeaconBase(i.wrapAsNeeded(world), pos, (IPartInfo)i, beacon));
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return this.anyMatch(world, pos, i -> i.getPart().isBurning(i.wrapAsNeeded(world), pos, (IPartInfo)i));
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material material, boolean testingHead) {
        return BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().values().stream().map(i -> i.getPart().isEntityInsideMaterial(i.wrapAsNeeded(world), pos, (IPartInfo)i, entity, yToTest, material, testingHead)).filter(is -> is != null).anyMatch(i -> i)).orElse(false);
    }

    public boolean isFertile(World world, BlockPos pos) {
        return this.anyMatch((IBlockAccess)world, pos, i -> i.getPart().isFertile((IPartInfo)i));
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.anyMatch((IBlockAccess)world, pos, i -> i.getPart().isFireSource((IPartInfo)i, side));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.anyMatch(world, pos, i -> i.getPart().isFlammable(i.wrapAsNeeded(world), pos, (IPartInfo)i, face));
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return this.anyMatch(world, pos, i -> i.getPart().isFoliage(i.wrapAsNeeded(world), pos, (IPartInfo)i));
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return super.isLadder(state, world, pos, entity);
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.anyMatch(world, pos, i -> i.getPart().isLeaves(i.wrapAsNeeded(world), pos, (IPartInfo)i));
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return this.anyMatch(world, pos, i -> i.getPart().isPassable(i.wrapAsNeeded(world), pos, (IPartInfo)i));
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return this.allMatch(world, pos, i -> i.getPart().isWood(i.wrapAsNeeded(world), pos, (IPartInfo)i));
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return super.func_176197_a(worldIn, pos, entityIn, motion);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.forEach((IBlockAccess)worldIn, pos, i -> i.getPart().neighborChanged((IPartInfo)i, blockIn, fromPos));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Pair<Vec3d, Vec3d> vectors = RayTraceHelper.getRayTraceVectors(player);
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null) {
            return BlockMultipartContainer.getTile((IBlockAccess)world, pos).map(t -> t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).map(i -> i.getPart().onPartActivated((IPartInfo)i, player, hand, (RayTraceResult)hit.hitInfo)).orElse(false);
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        Pair<Vec3d, Vec3d> vectors = RayTraceHelper.getRayTraceVectors(player);
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null) {
            BlockMultipartContainer.getTile((IBlockAccess)world, pos).map(t -> t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).ifPresent(i -> i.getPart().onPartClicked((IPartInfo)i, player, (RayTraceResult)hit.hitInfo));
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.forEach((IBlockAccess)world, pos, it -> {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            AxisAlignedBB bb = entity.func_70046_E();
            if (bb != null) {
                it.getPart().addCollisionBoxToList((IPartInfo)it, bb.func_186662_g(0.001), (List<AxisAlignedBB>)boxes, entity, false);
            }
            bb = entity.func_174813_aQ();
            it.getPart().addCollisionBoxToList((IPartInfo)it, bb.func_186662_g(0.001), (List<AxisAlignedBB>)boxes, entity, false);
            if (!boxes.isEmpty()) {
                it.getPart().onEntityCollidedWithPart((IPartInfo)it, entity);
            }
        });
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
    }

    public void func_176216_a(World world, Entity entity) {
        super.func_176216_a(world, entity);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        this.forEach(world, pos, i -> i.getPart().onNeighborChange((IPartInfo)i, neighbor));
    }

    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        this.forEach((IBlockAccess)world, pos, i -> i.getPart().onPlantGrow((IPartInfo)i, source));
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        this.forEach((IBlockAccess)world, pos, i -> i.getPart().randomTick((IPartInfo)i, random));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.forEach((IBlockAccess)world, pos, i -> {
            if (i.checkAndRemoveTick()) {
                i.getPart().updateTick((IPartInfo)i, rand);
            }
        });
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == null) {
            return BlockFaceShape.UNDEFINED;
        }
        return BlockMultipartContainer.getTile(world, pos).map(t -> SlotUtil.viewContainer(t, i -> i.getPart().getPartFaceShape((IPartInfo)i, face), l -> l.stream().filter(Predicate.isEqual(BlockFaceShape.UNDEFINED).negate()).findFirst().orElse(BlockFaceShape.UNDEFINED), BlockFaceShape.UNDEFINED, true, face)).orElse(BlockFaceShape.UNDEFINED);
    }

    private void forEach(IBlockAccess world, BlockPos pos, Consumer<PartInfo> consumer) {
        BlockMultipartContainer.getTile(world, pos).ifPresent(t -> t.getParts().values().forEach(consumer));
    }

    private boolean anyMatch(IBlockAccess world, BlockPos pos, Predicate<PartInfo> predicate) {
        return BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().values().stream().anyMatch(predicate)).orElse(false);
    }

    private boolean allMatch(IBlockAccess world, BlockPos pos, Predicate<PartInfo> predicate) {
        return BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().values().stream().allMatch(predicate)).orElse(false);
    }

    private int add(IBlockAccess world, BlockPos pos, ToIntFunction<PartInfo> converter, int max) {
        return Math.min(BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().values().stream().mapToInt(converter).reduce(0, (a, b) -> a + b)).orElse(0), max);
    }

    private int max(IBlockAccess world, BlockPos pos, ToIntFunction<PartInfo> converter) {
        return BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().values().stream().mapToInt(converter).max().orElse(0)).orElse(0);
    }

    private float addF(IBlockAccess world, BlockPos pos, ToDoubleFunction<PartInfo> converter, double max) {
        return (float)Math.min((double)BlockMultipartContainer.getTile(world, pos).map(t -> t.getParts().values().stream().mapToDouble(converter).reduce(0.0, (a, b) -> a + b)).orElse(0.0).floatValue(), max);
    }
}

