/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer;

import com.google.common.base.Preconditions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.Config;
import openmods.Log;
import openmods.renderer.PreWorldRenderHookVisitor;
import openmods.utils.render.FramebufferBlitter;
import openmods.utils.render.RenderUtils;

public class SkyBlockRenderer {
    public static final SkyBlockRenderer INSTANCE = new SkyBlockRenderer();
    private Framebuffer skyFb;
    private boolean isInitialized;
    private boolean isActive;
    private int stencilMask = -1;
    private int lastRenderUsers;
    private boolean skyCaptured;

    public boolean hasSkyTexture() {
        return this.isActive && this.skyCaptured;
    }

    public int getStencilMask() {
        return this.stencilMask;
    }

    public void incrementUsers() {
        ++this.lastRenderUsers;
    }

    public void setup() {
        Preconditions.checkState((!this.isInitialized ? 1 : 0) != 0, (Object)"Double initialization");
        this.isInitialized = true;
        if (!Config.renderSkyBlocks) {
            Log.info((String)"Disabled by config", (Object[])new Object[0]);
            return;
        }
        if (!OpenGlHelper.func_148822_b()) {
            Log.info((String)"Framebuffer not enabled", (Object[])new Object[0]);
            return;
        }
        if (!FramebufferBlitter.INSTANCE.isValid()) {
            Log.info((String)"Framebuffer blit not enabled", (Object[])new Object[0]);
            return;
        }
        if (!PreWorldRenderHookVisitor.isActive()) {
            Log.info((String)"Pre-world render hook not active", (Object[])new Object[0]);
            return;
        }
        Framebuffer mcFb = Minecraft.func_71410_x().func_147110_a();
        if (!mcFb.isStencilEnabled() && !mcFb.enableStencil()) {
            Log.info((String)"Stencil not enabled", (Object[])new Object[0]);
            return;
        }
        int stencilBit = MinecraftForgeClient.reserveStencilBit();
        if (stencilBit < 0) {
            Log.info((String)"All stencil bits reserved", (Object[])new Object[0]);
            return;
        }
        PreWorldRenderHookVisitor.setHook((Runnable)new SkyCapture());
        Log.debug((String)"Sky block rendering initialized correctly, stencilBit = %d", (Object[])new Object[]{stencilBit});
        this.stencilMask = 1 << stencilBit;
        this.isActive = true;
    }

    public void renderSkyTexture() {
        if (!this.isActive) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer mcFb = mc.func_147110_a();
        GlStateManager.func_179106_n();
        RenderUtils.disableLightmap();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        this.skyFb.func_147615_c(mc.field_71443_c, mc.field_71440_d);
        GlStateManager.func_179126_j();
        GlStateManager.func_179083_b((int)0, (int)0, (int)mcFb.field_147621_c, (int)mcFb.field_147618_d);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        RenderUtils.enableLightmap();
        GlStateManager.func_179127_m();
    }

    private class SkyCapture
    implements Runnable {
        private SkyCapture() {
        }

        @Override
        public void run() {
            SkyBlockRenderer.this.skyCaptured = SkyBlockRenderer.this.lastRenderUsers > 0;
            if (!SkyBlockRenderer.this.skyCaptured) {
                return;
            }
            SkyBlockRenderer.this.lastRenderUsers = 0;
            Framebuffer mcFb = Minecraft.func_71410_x().func_147110_a();
            if (SkyBlockRenderer.this.skyFb == null) {
                SkyBlockRenderer.this.skyFb = new Framebuffer(mcFb.field_147621_c, mcFb.field_147618_d, false);
            } else if (((SkyBlockRenderer)SkyBlockRenderer.this).skyFb.field_147621_c != mcFb.field_147621_c || ((SkyBlockRenderer)SkyBlockRenderer.this).skyFb.field_147618_d != mcFb.field_147618_d) {
                SkyBlockRenderer.this.skyFb.func_147613_a(mcFb.field_147621_c, mcFb.field_147618_d);
            }
            FramebufferBlitter.INSTANCE.blitFramebuffer(mcFb, SkyBlockRenderer.this.skyFb);
            mcFb.func_147610_a(false);
        }
    }
}

