/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Table;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.renderer.TextureUploader;
import openblocks.client.renderer.block.canvas.CanvasLayer;
import openblocks.client.renderer.block.canvas.CanvasSideState;
import openblocks.client.renderer.block.canvas.TextureOrientation;
import openmods.Log;

public class CanvasTextureManager {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("openblocks.debugCanvasTextures", "false"));
    public static final CanvasTextureManager INSTANCE = new CanvasTextureManager();
    private int peakRejectedAllocations = 0;
    private boolean textureLimitReached = false;
    private final Deque<CanvasTexture> freeTextures = Queues.newArrayDeque();
    private final Table<Integer, List<CanvasLayer>, CanvasTexture> usedTextures = HashBasedTable.create();

    public int getPeakRejectedAllocations() {
        return this.peakRejectedAllocations;
    }

    private CanvasTextureManager() {
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre evt) {
        this.freeTextures.clear();
        this.usedTextures.clear();
        this.peakRejectedAllocations = 0;
        this.textureLimitReached = false;
        CanvasSideState.onTextureReload();
        if (DEBUG) {
            Log.info((String)"Allocating %s textures", (Object[])new Object[]{Config.canvasPoolSize});
        }
        TextureMap map = evt.getMap();
        EmptyTextureData emptyTexture = new EmptyTextureData();
        for (int i = 0; i < Config.canvasPoolSize; ++i) {
            CanvasTexture entry = new CanvasTexture(OpenBlocks.location("canvas-" + i), emptyTexture);
            map.setTextureEntry((TextureAtlasSprite)entry);
            this.freeTextures.push(entry);
        }
    }

    public ResourceLocation getTexture(int background, List<CanvasLayer> layers) {
        CanvasTexture allocatedTexture = (CanvasTexture)this.usedTextures.get((Object)background, layers);
        if (allocatedTexture != null) {
            ++allocatedTexture.referenceCount;
            if (DEBUG) {
                Log.info((String)"Incrementing texture %s [%08X:%s]. counter = %d", (Object[])new Object[]{allocatedTexture.location, background, layers, allocatedTexture.referenceCount});
            }
            return allocatedTexture.location;
        }
        allocatedTexture = this.freeTextures.poll();
        if (allocatedTexture == null) {
            this.tryReclaimTextures();
            allocatedTexture = this.freeTextures.poll();
        }
        if (allocatedTexture == null) {
            ++this.peakRejectedAllocations;
            if (!this.textureLimitReached) {
                this.textureLimitReached = true;
                Log.warn((String)"Reached limit of canvas textures, change canvasPoolSize and reload resources (F3+T)", (Object[])new Object[0]);
            }
            if (DEBUG) {
                Log.info((String)"Can't load texture [%08X:%s]", (Object[])new Object[]{background, layers});
            }
            return ModelLoader.White.LOCATION;
        }
        this.peakRejectedAllocations = 0;
        allocatedTexture.prepareTexture(background, layers);
        this.usedTextures.put((Object)background, layers, (Object)allocatedTexture);
        ++allocatedTexture.referenceCount;
        if (DEBUG) {
            Log.info((String)"Loaded texture %s [%08X:%s]. counter = %d", (Object[])new Object[]{allocatedTexture.location, background, layers, allocatedTexture.referenceCount});
        }
        return allocatedTexture.location;
    }

    private void tryReclaimTextures() {
        Iterator cells = this.usedTextures.cellSet().iterator();
        while (cells.hasNext()) {
            Table.Cell cell = (Table.Cell)cells.next();
            CanvasTexture texture = (CanvasTexture)cell.getValue();
            if (texture.referenceCount > 0) continue;
            cells.remove();
            texture.referenceCount = 0;
            this.freeTextures.push(texture);
            if (!DEBUG) continue;
            Log.info((String)"Reclaiming texture %s [%08X:%s]", (Object[])new Object[]{texture.location, cell.getRowKey(), cell.getColumnKey()});
        }
    }

    public void releaseTexture(int background, List<CanvasLayer> layers) {
        CanvasTexture textureToRelease = (CanvasTexture)this.usedTextures.get((Object)background, layers);
        Preconditions.checkNotNull((Object)textureToRelease, (Object)"Texture not allocated");
        --textureToRelease.referenceCount;
        if (DEBUG) {
            Log.info((String)"Decrementing texture %s [%08X:%s]. counter = %d", (Object[])new Object[]{textureToRelease.location, background, layers, textureToRelease.referenceCount});
        }
    }

    private class CanvasTexture
    extends TextureAtlasSprite
    implements TextureUploader.IUploadableTexture {
        public final ResourceLocation location;
        private final EmptyTextureData emptyTexture;
        public int referenceCount;
        private int mipmapLevels;
        private boolean requiresUpload;

        public CanvasTexture(ResourceLocation location, EmptyTextureData emptyTexture) {
            super(location.toString());
            this.referenceCount = 0;
            this.location = location;
            this.field_130223_c = 16;
            this.field_130224_d = 16;
            this.emptyTexture = emptyTexture;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            return false;
        }

        public void func_147963_d(int level) {
            this.func_130103_l();
            this.field_110976_a.add(this.emptyTexture.getContents(level));
            this.mipmapLevels = level;
        }

        public void prepareTexture(int background, List<CanvasLayer> layers) {
            if (!layers.isEmpty() && layers.get((int)0).orientation != TextureOrientation.R0) {
                Log.warn((String)"Unoptimized texture: %s!", (Object[])new Object[]{layers});
            }
            this.func_130103_l();
            int[][] mipmaps = new int[this.mipmapLevels + 1][];
            int size = 256;
            mipmaps[0] = new int[256];
            int[] contents = mipmaps[0];
            for (int i = 0; i < 256; ++i) {
                int color = background;
                for (CanvasLayer layer : layers) {
                    int transformedIndex = layer.orientation.rotate16x16(i);
                    color = layer.pattern.mix(transformedIndex, layer.color, color);
                }
                contents[i] = color;
            }
            this.field_110976_a.add(mipmaps);
            super.func_147963_d(this.mipmapLevels);
            this.requiresUpload = true;
            TextureUploader.INSTANCE.scheduleTextureUpload(this);
        }

        @Override
        public void upload() {
            if (this.requiresUpload) {
                this.requiresUpload = false;
                TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(0)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        }
    }

    private static class EmptyTextureData {
        final Map<Integer, int[][]> mipmapLevels = Maps.newHashMap();

        private EmptyTextureData() {
        }

        public int[][] getContents(int mipmapLevel) {
            int[][] contents = this.mipmapLevels.get(mipmapLevel);
            if (contents == null) {
                contents = EmptyTextureData.generateEmptyMipmap(mipmapLevel);
                this.mipmapLevels.put(mipmapLevel, contents);
            }
            return contents;
        }

        private static int[][] generateEmptyMipmap(int mipmapLevel) {
            int[][] result = new int[mipmapLevel + 1][];
            int size = 256;
            for (int i = 0; i <= mipmapLevel; ++i) {
                result[i] = new int[size];
                size >>= 2;
            }
            return result;
        }
    }
}

