/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.common.block.BlockImaginary;
import openblocks.common.tileentity.TileEntityImaginary;

public class TileEntityImaginaryRenderer
extends FastTESR<TileEntityImaginary> {
    private static BlockRendererDispatcher blockRenderer;
    private static final int BYTES_PER_INT = 4;
    private static final int VERTICES_PER_QUAD = 4;
    private static final IVertexElementWriter FIXED_COLOR_WRITER;
    private static final IVertexElementWriter FIXED_BRIGHTNESS_WRITER;
    private static final LoadingCache<IBlockState, List<VertexWriter>> MODEL_CACHE;

    private static Map<VertexFormatElement, Integer> createElementOffsetMap(VertexFormat format) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < format.func_177345_h(); ++i) {
            VertexFormatElement vfe = format.func_177348_c(i);
            if (vfe.func_177375_c() == VertexFormatElement.EnumUsage.PADDING) continue;
            builder.put((Object)vfe, (Object)format.func_181720_d(i));
        }
        return builder.build();
    }

    private static void convertQuad(BakedQuad quad, List<VertexWriter> output) {
        VertexFormat inputFormat = quad.getFormat();
        Map<VertexFormatElement, Integer> inputFormatMap = TileEntityImaginaryRenderer.createElementOffsetMap(inputFormat);
        int[] vertexData = quad.func_178209_a();
        ByteBuffer inputBuffer = ByteBuffer.allocate(vertexData.length * 4);
        inputBuffer.asIntBuffer().put(vertexData);
        inputBuffer.clear();
        Integer positionOffset = inputFormatMap.get(DefaultVertexFormats.field_181713_m);
        if (positionOffset == null) {
            throw new AssertionError((Object)("Invalid format: " + inputFormat));
        }
        Integer colorOffset = inputFormatMap.get(DefaultVertexFormats.field_181714_n);
        Integer textureOffset = inputFormatMap.get(DefaultVertexFormats.field_181715_o);
        if (textureOffset == null) {
            throw new AssertionError((Object)("Invalid format: " + inputFormat));
        }
        int vertexSize = inputFormat.func_181719_f() * 4;
        int vertexOffset = 0;
        for (int i = 0; i < 4; ++i) {
            IVertexElementWriter[] vertexWriters = new IVertexElementWriter[]{TileEntityImaginaryRenderer.createPositionWriter(inputBuffer, vertexOffset + positionOffset), colorOffset != null ? TileEntityImaginaryRenderer.createColorWriter(inputBuffer, vertexOffset + colorOffset) : FIXED_COLOR_WRITER, TileEntityImaginaryRenderer.createTextureWriter(inputBuffer, vertexOffset + textureOffset), FIXED_BRIGHTNESS_WRITER};
            output.add(new VertexWriter(vertexWriters));
            vertexOffset += vertexSize;
        }
    }

    private static IVertexElementWriter createPositionWriter(ByteBuffer inputBuffer, int position) {
        inputBuffer.position(position);
        final float x = inputBuffer.getFloat();
        final float y = inputBuffer.getFloat();
        final float z = inputBuffer.getFloat();
        return new IVertexElementWriter(){

            @Override
            public void write(ByteBuffer output, RenderInfo info) {
                output.putFloat((float)((double)x + info.x));
                output.putFloat((float)((double)y + info.y));
                output.putFloat((float)((double)z + info.z));
            }
        };
    }

    private static IVertexElementWriter createColorWriter(ByteBuffer inputBuffer, int position) {
        inputBuffer.position(position);
        final float inputA = inputBuffer.get() & 0xFF;
        final float inputB = inputBuffer.get() & 0xFF;
        final float inputG = inputBuffer.get() & 0xFF;
        final float inputR = inputBuffer.get() & 0xFF;
        return new IVertexElementWriter(){

            @Override
            public void write(ByteBuffer output, RenderInfo info) {
                int alpha = Math.min(255, (int)(inputA * info.a));
                int red = Math.min(255, (int)(inputR * info.r));
                int green = Math.min(255, (int)(inputG * info.g));
                int blue = Math.min(255, (int)(inputB * info.b));
                output.put((byte)red);
                output.put((byte)green);
                output.put((byte)blue);
                output.put((byte)alpha);
            }
        };
    }

    private static IVertexElementWriter createTextureWriter(ByteBuffer inputBuffer, int position) {
        inputBuffer.position(position);
        final float u = inputBuffer.getFloat();
        final float v = inputBuffer.getFloat();
        return new IVertexElementWriter(){

            @Override
            public void write(ByteBuffer output, RenderInfo info) {
                output.putFloat(u);
                output.putFloat(v);
            }
        };
    }

    private static void addQuads(List<BakedQuad> quads, List<VertexWriter> output) {
        for (BakedQuad quad : quads) {
            TileEntityImaginaryRenderer.convertQuad(quad, output);
        }
    }

    public void renderTileEntityFast(TileEntityImaginary te, double x, double y, double z, float partialTicks, int destroyStage, float alpha, BufferBuilder buffer) {
        float b;
        float g;
        float r;
        if (te == null) {
            return;
        }
        boolean isVisible = te.is(TileEntityImaginary.Property.VISIBLE);
        if (isVisible && te.visibility < 1.0f) {
            te.visibility = Math.min(te.visibility + Config.imaginaryFadingSpeed, 1.0f);
        } else if (!isVisible && te.visibility > 0.0f) {
            te.visibility = Math.max(te.visibility - Config.imaginaryFadingSpeed, 0.0f);
        }
        if (te.visibility <= 0.0f) {
            return;
        }
        if (te.isPencil()) {
            r = 1.0f;
            g = 1.0f;
            b = 1.0f;
        } else {
            int color = te.color;
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color >> 0 & 0xFF) / 255.0f;
        }
        float a = te.visibility;
        RenderInfo info = new RenderInfo(x, y, z, r, g, b, a);
        BlockPos pos = te.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        if (state.func_177230_c() instanceof BlockImaginary) {
            List vertexWriters = (List)MODEL_CACHE.getUnchecked((Object)state);
            for (VertexWriter writer : vertexWriters) {
                writer.write(buffer, info);
            }
        }
    }

    static {
        FIXED_COLOR_WRITER = new IVertexElementWriter(){

            @Override
            public void write(ByteBuffer output, RenderInfo info) {
                output.put((byte)Math.min(255.0f, 255.0f * info.a));
                output.put((byte)Math.min(255.0f, 255.0f * info.b));
                output.put((byte)Math.min(255.0f, 255.0f * info.g));
                output.put((byte)Math.min(255.0f, 255.0f * info.r));
            }
        };
        FIXED_BRIGHTNESS_WRITER = new IVertexElementWriter(){

            @Override
            public void write(ByteBuffer output, RenderInfo info) {
                output.putInt(0xF000F0);
            }
        };
        MODEL_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<IBlockState, List<VertexWriter>>(){

            public List<VertexWriter> load(IBlockState state) throws Exception {
                if (blockRenderer == null) {
                    blockRenderer = Minecraft.func_71410_x().func_175602_ab();
                }
                IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
                ArrayList vertexWriters = Lists.newArrayList();
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    TileEntityImaginaryRenderer.addQuads(model.func_188616_a(state, side, 0L), vertexWriters);
                }
                TileEntityImaginaryRenderer.addQuads(model.func_188616_a(state, null, 0L), vertexWriters);
                return ImmutableList.copyOf((Collection)vertexWriters);
            }
        });
    }

    public static class CacheFlushListener {
        @SubscribeEvent
        public void onModelBake(ModelBakeEvent evt) {
            MODEL_CACHE.invalidateAll();
        }
    }

    private static class VertexWriter {
        private final IVertexElementWriter[] writers;

        public VertexWriter(IVertexElementWriter[] writers) {
            this.writers = writers;
        }

        public void write(BufferBuilder buffer, RenderInfo info) {
            ByteBuffer outputBuffer = buffer.func_178966_f();
            for (IVertexElementWriter writer : this.writers) {
                writer.write(outputBuffer, info);
            }
            buffer.func_181675_d();
        }
    }

    private static interface IVertexElementWriter {
        public void write(ByteBuffer var1, RenderInfo var2);
    }

    private static class RenderInfo {
        public final double x;
        public final double y;
        public final double z;
        public final float r;
        public final float g;
        public final float b;
        public final float a;

        public RenderInfo(double x, double y, double z, float r, float g, float b, float a) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }
    }
}

