/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityTarget;
import openmods.Log;
import openmods.block.OpenBlock;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.utils.BlockUtils;

public class BlockTarget
extends OpenBlock.FourDirections {
    private static final AxisAlignedBB FOLDED_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.1f, 1.0);
    private static final AxisAlignedBB DEPLOYED_AABB = new AxisAlignedBB(0.0, 0.0, 0.9, 1.0, 1.0, 1.0);
    private int lastEntityHit = 0;
    public static final IProperty<Boolean> POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final int MASK_POWERED = 8;

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b(POWERED) != false ? 8 : 0);
    }

    public BlockTarget() {
        super(Material.field_151576_e);
        this.func_149715_a(0.3f);
        this.setRequiresInitialization(true);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity != null && entity instanceof EntityArrow) {
            if (this.lastEntityHit != entity.func_145782_y()) {
                this.lastEntityHit = entity.func_145782_y();
                return;
            }
            this.lastEntityHit = entity.func_145782_y();
            this.onTargetHit(world, pos, state, new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        }
    }

    public void onTargetHit(World world, BlockPos pos, IBlockState state, Vec3d entityPosition) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)state.func_177229_b(POWERED)).booleanValue()) {
            return;
        }
        EnumFacing opposite = this.getFront(state).func_176734_d();
        double centerX = (double)pos.func_177958_n() + 0.5 + (double)opposite.func_82601_c() * 0.5;
        double centerY = (double)pos.func_177956_o() + 0.55 + (double)opposite.func_96559_d() * 0.45;
        double centerZ = (double)pos.func_177952_p() + 0.5 + (double)opposite.func_82599_e() * 0.5;
        Vec3d bullseye = new Vec3d(centerX, centerY, centerZ);
        double distance = entityPosition.func_72438_d(bullseye);
        TileEntityTarget target = (TileEntityTarget)((Object)BlockTarget.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityTarget.class));
        target.setRedstoneStrength(15 - Math.min(15, Math.max(0, (int)(distance * 32.0))));
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityTarget tile = (TileEntityTarget)((Object)BlockTarget.getTileEntity((IBlockAccess)blockAccess, (BlockPos)pos, TileEntityTarget.class));
        return tile != null ? tile.getRedstoneStrength() : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b(POWERED)).booleanValue()) {
            Orientation orientation = (Orientation)state.func_177229_b(this.propertyOrientation);
            return BlockSpaceTransform.instance.mapBlockToWorld(orientation, DEPLOYED_AABB);
        }
        return FOLDED_AABB;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return this.isOnTopOfSolidBlock(world, pos, side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos blockPos, Block neighbour, BlockPos neigbourPos) {
        BlockTarget.updateRedstone(world, blockPos, state);
        super.func_189540_a(state, world, blockPos, neighbour, neigbourPos);
    }

    protected boolean onBlockAddedNextTick(World world, BlockPos blockPos, IBlockState state) {
        BlockTarget.updateRedstone(world, blockPos, state);
        return super.onBlockAddedNextTick(world, blockPos, state);
    }

    private static void updateRedstone(World world, BlockPos blockPos, IBlockState state) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        boolean isPowered = world.func_175687_A(blockPos) > 0;
        IBlockState newState = state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(isPowered));
        if (state != newState) {
            BlockTarget.dropArrowsAsItems((WorldServer)world, blockPos);
            BlockUtils.playSoundAtPos((World)world, (BlockPos)blockPos, (SoundEvent)(isPowered ? OpenBlocks.Sounds.BLOCK_TARGET_OPEN : OpenBlocks.Sounds.BLOCK_TARGET_CLOSE), (SoundCategory)SoundCategory.BLOCKS, (float)0.5f, (float)1.0f);
            world.func_180501_a(blockPos, newState, 3);
        }
    }

    private static void dropArrowsAsItems(WorldServer world, BlockPos pos) {
        AxisAlignedBB aabb = BlockUtils.aabbOffset((BlockPos)pos, (double)-0.2, (double)-0.2, (double)-0.2, (double)1.2, (double)1.2, (double)1.2);
        final List arrows = world.func_72872_a(EntityArrow.class, aabb);
        final ArrayList drops = Lists.newArrayList();
        int failed = (Integer)FakePlayerPool.instance.executeOnPlayer(world, (FakePlayerPool.PlayerUserReturning)new FakePlayerPool.PlayerUserReturning<Integer>(){

            public Integer usePlayer(OpenModsFakePlayer fakePlayer) {
                int failed = 0;
                for (EntityArrow arrow : arrows) {
                    if (arrow.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY) {
                        arrow.func_70106_y();
                        continue;
                    }
                    try {
                        arrow.func_70100_b_((EntityPlayer)fakePlayer);
                    }
                    catch (Throwable t) {
                        Log.warn((Throwable)t, (String)"Failed to collide arrow %s with fake player, returing vanilla one", (Object[])new Object[]{arrow});
                        ++failed;
                    }
                }
                InventoryPlayer inventory = fakePlayer.field_71071_by;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    drops.add(stack);
                }
                inventory.func_174888_l();
                return failed;
            }
        });
        for (ItemStack drop : drops) {
            BlockUtils.dropItemStackInWorld((World)world, (Vec3i)pos, (ItemStack)drop);
        }
        if (failed > 0) {
            BlockUtils.dropItemStackInWorld((World)world, (Vec3i)pos, (ItemStack)new ItemStack(Items.field_151032_g, failed));
        }
    }
}

