/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.shapes.CoordShape;
import openblocks.shapes.GuideShape;
import openmods.Log;
import openmods.api.IAddAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.block.OpenBlock;
import openmods.colors.ColorMeta;
import openmods.geometry.HalfAxis;
import openmods.geometry.Orientation;
import openmods.shapes.IShapeGenerator;
import openmods.shapes.IShapeable;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableEnum;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableVarInt;
import openmods.sync.drops.DroppableTileEntity;
import openmods.sync.drops.StoreOnDrop;
import openmods.utils.CollectionUtils;
import openmods.utils.MathUtils;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.struct.ScriptStruct;
import openperipheral.api.struct.StructField;

public class TileEntityGuide
extends DroppableTileEntity
implements ISyncListener,
INeighbourAwareTile,
IAddAwareTile,
ITickable {
    private static final Map<String, IShapeManipulator> COMMANDS;
    private static final Comparator<BlockPos> COMPARATOR;
    private CoordShape shape;
    private CoordShape previousShape;
    private CoordShape toDeleteShape;
    private float timeSinceChange = 0.0f;
    private AxisAlignedBB renderAABB;
    @StoreOnDrop(name="PosX")
    protected SyncableVarInt posX;
    @StoreOnDrop(name="PosY")
    protected SyncableVarInt posY;
    @StoreOnDrop(name="PosZ")
    protected SyncableVarInt posZ;
    @StoreOnDrop(name="NegX")
    protected SyncableVarInt negX;
    @StoreOnDrop(name="NegY")
    protected SyncableVarInt negY;
    @StoreOnDrop(name="NegZ")
    protected SyncableVarInt negZ;
    @StoreOnDrop(name="Mode")
    protected SyncableEnum<GuideShape> mode;
    @StoreOnDrop(name="Color")
    protected SyncableInt color;
    protected SyncableBoolean active;
    private final Map<HalfAxis, SyncableVarInt> axisDimensions = Maps.newEnumMap(HalfAxis.class);

    private static IShapeManipulator createHalfAxisIncrementer(final HalfAxis halfAxis) {
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                return te.incrementHalfAxis(halfAxis, player);
            }
        };
    }

    private static IShapeManipulator createHalfAxisDecrementer(final HalfAxis halfAxis) {
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                return te.decrementHalfAxis(halfAxis, player);
            }
        };
    }

    private static IShapeManipulator createHalfAxisCopier(final HalfAxis halfAxis) {
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                return te.copyHalfAxis(halfAxis, halfAxis.negate(), player);
            }
        };
    }

    private static IShapeManipulator createRotationManipulator(final HalfAxis ha) {
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                BlockPos pos;
                World world = te.func_145831_w();
                IBlockState state = world.func_180495_p(pos = te.func_174877_v());
                Block block = state.func_177230_c();
                if (block instanceof OpenBlock) {
                    IProperty orientationProperty = ((OpenBlock)block).propertyOrientation;
                    Orientation orientation = (Orientation)state.func_177229_b(orientationProperty);
                    Orientation newOrientation = orientation.rotateAround(ha);
                    world.func_175656_a(pos, state.func_177226_a(orientationProperty, (Comparable)newOrientation));
                    return true;
                }
                return false;
            }
        };
    }

    public TileEntityGuide() {
        this.axisDimensions.put(HalfAxis.NEG_X, this.negX);
        this.axisDimensions.put(HalfAxis.NEG_Y, this.negY);
        this.axisDimensions.put(HalfAxis.NEG_Z, this.negZ);
        this.axisDimensions.put(HalfAxis.POS_X, this.posX);
        this.axisDimensions.put(HalfAxis.POS_Y, this.posY);
        this.axisDimensions.put(HalfAxis.POS_Z, this.posZ);
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addUpdateListener((ISyncListener)this);
    }

    protected void createSyncedFields() {
        this.posX = new SyncableVarInt(8);
        this.posY = new SyncableVarInt(8);
        this.posZ = new SyncableVarInt(8);
        this.negX = new SyncableVarInt(8);
        this.negY = new SyncableVarInt(8);
        this.negZ = new SyncableVarInt(8);
        this.mode = SyncableEnum.create((Enum)GuideShape.Sphere);
        this.color = new SyncableInt(0xFFFFFF);
        this.active = new SyncableBoolean();
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.TABLE})
    public ShapeSize getSize() {
        ShapeSize result = new ShapeSize();
        result.negX = this.negX.get();
        result.negY = this.negY.get();
        result.negZ = this.negZ.get();
        result.posX = this.posX.get();
        result.posY = this.posY.get();
        result.posZ = this.posZ.get();
        return result;
    }

    @ScriptCallable
    public void setSize(ShapeSize size) {
        Preconditions.checkArgument((size.negX > 0 ? 1 : 0) != 0, (Object)"NegX must be > 0");
        this.negX.set(size.negX);
        Preconditions.checkArgument((size.negY > 0 ? 1 : 0) != 0, (Object)"NegY must be > 0");
        this.negY.set(size.negY);
        Preconditions.checkArgument((size.negZ > 0 ? 1 : 0) != 0, (Object)"NegZ must be > 0");
        this.negZ.set(size.negZ);
        Preconditions.checkArgument((size.posX > 0 ? 1 : 0) != 0, (Object)"PosX must be > 0");
        this.posX.set(size.posX);
        Preconditions.checkArgument((size.negY > 0 ? 1 : 0) != 0, (Object)"PosY must be > 0");
        this.posY.set(size.posY);
        Preconditions.checkArgument((size.negZ > 0 ? 1 : 0) != 0, (Object)"PosZ must be > 0");
        this.posZ.set(size.posZ);
        this.recreateShape();
        this.sync();
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.NUMBER})
    public int getColor() {
        return this.color.get() & 0xFFFFFF;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.NUMBER})
    public int getCount() {
        if (this.shape == null) {
            this.recreateShape();
        }
        return this.shape.size();
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.STRING}, name="getShape")
    public GuideShape getCurrentMode() {
        return (GuideShape)this.mode.get();
    }

    @ScriptCallable
    public void setShape(@Arg(name="shape") GuideShape shape) {
        this.mode.set((Enum)shape);
        this.recreateShape();
        this.sync();
    }

    @ScriptCallable
    public void setColor(@Arg(name="color") int color) {
        this.color.set(color & 0xFFFFFF);
        this.sync();
    }

    private boolean incrementHalfAxis(HalfAxis axis, EntityPlayerMP player) {
        SyncableVarInt v = this.axisDimensions.get(axis);
        v.modify(1);
        this.afterDimensionsChange((EntityPlayer)player);
        return true;
    }

    private boolean decrementHalfAxis(HalfAxis axis, EntityPlayerMP player) {
        SyncableVarInt v = this.axisDimensions.get(axis);
        if (v.get() > 0) {
            v.modify(-1);
            this.afterDimensionsChange((EntityPlayer)player);
            return true;
        }
        return false;
    }

    private boolean copyHalfAxis(HalfAxis from, HalfAxis to, EntityPlayerMP player) {
        SyncableVarInt fromV = this.axisDimensions.get(from);
        SyncableVarInt toV = this.axisDimensions.get(to);
        toV.set(fromV.get());
        this.afterDimensionsChange((EntityPlayer)player);
        return true;
    }

    private void incrementMode(EntityPlayer player) {
        this.incrementMode();
        this.displayModeChange(player);
        this.displayBlockCount(player);
    }

    private void decrementMode(EntityPlayer player) {
        this.decrementMode();
        this.displayModeChange(player);
        this.displayBlockCount(player);
    }

    private void displayModeChange(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.change_mode", new Object[]{this.getCurrentMode().getLocalizedName()}));
    }

    private void displayBlockCount(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.total_blocks", new Object[]{this.shape.size()}));
    }

    public boolean shouldRender() {
        return Config.guideRedstone == 0 || Config.guideRedstone < 0 ^ this.active.get();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && (double)this.timeSinceChange < 1.0) {
            this.timeSinceChange = (float)Math.min(1.0, (double)this.timeSinceChange + 0.1);
        }
    }

    public float getTimeSinceChange() {
        return this.timeSinceChange;
    }

    private void recreateShape() {
        this.toDeleteShape = this.previousShape;
        this.previousShape = this.shape;
        this.shape = new CoordShape(this.generateShape());
        this.renderAABB = null;
    }

    private List<BlockPos> generateShape() {
        IShapeGenerator generator = this.getCurrentMode().generator;
        final HashSet uniqueResults = Sets.newHashSet();
        IShapeable collector = new IShapeable(){

            public void setBlock(int x, int y, int z) {
                if (TileEntityGuide.this.canAddCoord(x, y, z)) {
                    uniqueResults.add(new BlockPos(x, y, z));
                }
            }
        };
        generator.generateShape(-this.negX.get(), -this.negY.get(), -this.negZ.get(), this.posX.get(), this.posY.get(), this.posZ.get(), collector);
        ArrayList sortedResults = Lists.newArrayList((Iterable)uniqueResults);
        Collections.sort(sortedResults, COMPARATOR);
        ArrayList rotatedResult = Lists.newArrayList();
        Orientation orientation = this.getOrientation();
        for (BlockPos c : sortedResults) {
            int tx = orientation.transformX(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
            int ty = orientation.transformY(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
            int tz = orientation.transformZ(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
            rotatedResult.add(new BlockPos(tx, ty, tz));
        }
        return ImmutableList.copyOf((Collection)rotatedResult);
    }

    protected boolean canAddCoord(int x, int y, int z) {
        return x != 0 || y != 0 || z != 0;
    }

    public CoordShape getShape() {
        return this.shape;
    }

    public CoordShape getPreviousShape() {
        return this.previousShape;
    }

    public CoordShape getAndDeleteShape() {
        CoordShape toDel = this.toDeleteShape;
        this.toDeleteShape = null;
        return toDel;
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (!this.field_145850_b.field_72995_K) {
            this.recreateShape();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.createRenderAABB();
        }
        return this.renderAABB;
    }

    private AxisAlignedBB createRenderAABB() {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        if (this.shape != null) {
            for (BlockPos c : this.shape.getCoords()) {
                int z;
                int y;
                int x = c.func_177958_n();
                if (maxX < (double)x) {
                    maxX = x;
                }
                if (minX > (double)x) {
                    minX = x;
                }
                if (maxY < (double)(y = c.func_177956_o())) {
                    maxY = y;
                }
                if (minY > (double)y) {
                    minY = y;
                }
                if (maxZ < (double)(z = c.func_177952_p())) {
                    maxZ = z;
                }
                if (!(minZ > (double)z)) continue;
                minZ = z;
            }
        }
        return new AxisAlignedBB(this.field_174879_c.func_177963_a(minX, minY, minZ), this.field_174879_c.func_177963_a(maxX, maxY, maxZ));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Config.guideRenderRangeSq;
    }

    @Alias(value={"cycleShape"})
    @ScriptCallable(returnTypes={ReturnType.STRING})
    public GuideShape incrementMode() {
        GuideShape shape = (GuideShape)this.mode.increment();
        this.recreateShape();
        this.sync();
        return shape;
    }

    @ScriptCallable(returnTypes={ReturnType.STRING})
    public GuideShape decrementMode() {
        GuideShape shape = (GuideShape)this.mode.decrement();
        this.recreateShape();
        this.sync();
        return shape;
    }

    private void notifyPlayer(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.change_box_size", new Object[]{-this.negX.get(), -this.negY.get(), -this.negZ.get(), this.posX.get(), this.posY.get(), this.posZ.get()}));
        this.displayBlockCount(player);
    }

    private void afterDimensionsChange(EntityPlayer player) {
        this.recreateShape();
        this.sync();
        this.notifyPlayer(player);
    }

    public void onSync(Set<ISyncableObject> changes) {
        if (changes.contains(this.negX) || changes.contains(this.negY) || changes.contains(this.negZ) || changes.contains(this.posX) || changes.contains(this.posY) || changes.contains(this.posZ) || changes.contains(this.mode)) {
            this.recreateShape();
            this.timeSinceChange = 0.0f;
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && this.shouldRender();
    }

    private void updateRedstone() {
        if (Config.guideRedstone != 0) {
            boolean redstoneState = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
            this.active.set(redstoneState);
            this.sync();
        }
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        this.updateRedstone();
    }

    public void onAdded() {
        this.updateRedstone();
    }

    protected CoordShape getShapeSafe() {
        if (this.shape == null) {
            this.recreateShape();
        }
        return this.shape;
    }

    public boolean onItemUse(EntityPlayerMP player, @Nonnull ItemStack heldStack, EnumFacing side, float hitX, float hitY, float hitZ) {
        Set colors = ColorMeta.fromStack((ItemStack)heldStack);
        if (!colors.isEmpty()) {
            ColorMeta selected = (ColorMeta)CollectionUtils.getRandom((Collection)colors);
            this.color.set(selected.rgb);
            this.trySync();
            return true;
        }
        return false;
    }

    public void onCommand(EntityPlayer sender, String commandId) {
        if (sender instanceof EntityPlayerMP) {
            IShapeManipulator command = COMMANDS.get(commandId);
            if (command != null) {
                command.activate(this, (EntityPlayerMP)sender);
            } else {
                Log.info((String)"Player %s tried to send invalid command '%s' to guide %s", (Object[])new Object[]{sender, commandId, this});
            }
        }
    }

    static {
        ImmutableMap.Builder commands = ImmutableMap.builder();
        for (HalfAxis ha : HalfAxis.VALUES) {
            String name = ha.name().toLowerCase();
            commands.put((Object)("inc_" + name), (Object)TileEntityGuide.createHalfAxisIncrementer(ha));
            commands.put((Object)("dec_" + name), (Object)TileEntityGuide.createHalfAxisDecrementer(ha));
            commands.put((Object)("copy_" + name), (Object)TileEntityGuide.createHalfAxisCopier(ha));
        }
        commands.put((Object)"rotate_ccw", (Object)TileEntityGuide.createRotationManipulator(HalfAxis.NEG_Y));
        commands.put((Object)"rotate_cw", (Object)TileEntityGuide.createRotationManipulator(HalfAxis.POS_Y));
        commands.put((Object)"inc_mode", (Object)new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                te.incrementMode((EntityPlayer)player);
                return true;
            }
        });
        commands.put((Object)"dec_mode", (Object)new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                te.decrementMode((EntityPlayer)player);
                return true;
            }
        });
        COMMANDS = commands.build();
        COMPARATOR = new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos o1, BlockPos o2) {
                double angle2;
                int result = Ints.compare((int)o1.func_177958_n(), (int)o2.func_177958_n());
                if (result != 0) {
                    return result;
                }
                double angle1 = Math.atan2(o1.func_177952_p(), o1.func_177958_n());
                int result2 = Doubles.compare((double)angle1, (double)(angle2 = Math.atan2(o2.func_177952_p(), o2.func_177958_n())));
                if (result2 != 0) {
                    return result2;
                }
                double length1 = MathUtils.lengthSq((double)o1.func_177958_n(), (double)o1.func_177952_p());
                double length2 = MathUtils.lengthSq((double)o2.func_177958_n(), (double)o2.func_177952_p());
                result2 = Doubles.compare((double)length2, (double)length1);
                if (result2 != 0) {
                    return result2;
                }
                result = Ints.compare((int)o1.func_177958_n(), (int)o2.func_177958_n());
                if (result != 0) {
                    return result;
                }
                result = Ints.compare((int)o1.func_177952_p(), (int)o2.func_177952_p());
                return result;
            }
        };
    }

    @ScriptStruct
    public static class ShapeSize {
        @StructField
        public int negX;
        @StructField
        public int negY;
        @StructField
        public int negZ;
        @StructField
        public int posX;
        @StructField
        public int posY;
        @StructField
        public int posZ;
    }

    private static interface IShapeManipulator {
        public boolean activate(TileEntityGuide var1, EntityPlayerMP var2);
    }
}

