/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.OpenBlocks;
import openblocks.api.IFlimFlamDescription;
import openblocks.enchantments.flimflams.FlimFlamRegistry;
import openmods.Log;

public class FlimFlamEnchantmentsHandler {
    public static final int LUCK_MARGIN = -30;
    public static final int EFFECT_DELAY = 300;
    private static final Random RANDOM = new Random();
    private static final ResourceLocation CAPABILITY_KEY = OpenBlocks.location("luck");
    @CapabilityInject(value=Luck.class)
    private static Capability<Luck> CAPABILITY;

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(Luck.class, (Capability.IStorage)new Capability.IStorage<Luck>(){

            public NBTBase writeNBT(Capability<Luck> capability, Luck instance, EnumFacing side) {
                return new NBTTagInt(instance.luck);
            }

            public void readNBT(Capability<Luck> capability, Luck instance, EnumFacing side, NBTBase nbt) {
                instance.luck = ((NBTTagInt)nbt).func_150287_d();
            }
        }, (Callable)new Callable<Luck>(){

            @Override
            public Luck call() throws Exception {
                return new Luck();
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityInjector());
    }

    @Nullable
    private static Luck getProperty(Entity entity) {
        return CAPABILITY != null ? (Luck)entity.getCapability(CAPABILITY, EnumFacing.UP) : null;
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent e) {
        int flimFlamsToApply;
        EntityPlayer flimFlamTarget;
        EntityLivingBase entityLiving = e.getEntityLiving();
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        if (entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer targetPlayer = (EntityPlayer)entityLiving;
        if (e.getSource() == null) {
            return;
        }
        Entity damageSource = e.getSource().func_76346_g();
        if (!(damageSource instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer sourcePlayer = (EntityPlayer)damageSource;
        if (sourcePlayer == targetPlayer) {
            return;
        }
        int sourceFlimFlam = FlimFlamEnchantmentsHandler.getFlimFlamToolLevel(sourcePlayer);
        int targetFlimFlam = FlimFlamEnchantmentsHandler.getFlimFlamArmorLevel(targetPlayer);
        int flimFlamDiff = targetFlimFlam / 3 - sourceFlimFlam;
        if (flimFlamDiff == 0) {
            return;
        }
        if (flimFlamDiff > 0) {
            flimFlamTarget = sourcePlayer;
            flimFlamsToApply = flimFlamDiff;
        } else {
            flimFlamTarget = targetPlayer;
            flimFlamsToApply = -flimFlamDiff;
        }
        Luck victimLuck = FlimFlamEnchantmentsHandler.getProperty((Entity)flimFlamTarget);
        if (victimLuck != null) {
            for (int i = 0; i < flimFlamsToApply; ++i) {
                int roll = FlimFlamEnchantmentsHandler.rollD20();
                if (roll == 20) {
                    victimLuck.forceNext = true;
                }
                victimLuck.luck -= roll;
            }
            if (victimLuck.luck < -30) {
                victimLuck.forceNext = true;
            }
        }
    }

    private static int rollD20() {
        return RANDOM.nextInt(20) + 1;
    }

    public static void deliverKarma(EntityPlayerMP player) {
        if (player.field_70128_L) {
            return;
        }
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        if (property == null || !FlimFlamEnchantmentsHandler.canFlimFlam(property)) {
            return;
        }
        int luck = property.luck;
        int totalWeight = 0;
        ArrayList selectedEffects = Lists.newArrayList();
        for (IFlimFlamDescription effectMeta : FlimFlamRegistry.instance.getFlimFlams()) {
            if (!effectMeta.canApply(luck) || FlimFlamRegistry.BLACKLIST.isBlacklisted(effectMeta)) continue;
            selectedEffects.add(effectMeta);
            totalWeight += effectMeta.weight();
        }
        if (selectedEffects.isEmpty()) {
            return;
        }
        Collections.shuffle(selectedEffects);
        block3: while (!selectedEffects.isEmpty()) {
            int selectedWeight = RANDOM.nextInt(totalWeight);
            int currentWeight = 0;
            Iterator it = selectedEffects.iterator();
            while (it.hasNext()) {
                IFlimFlamDescription effectMeta = (IFlimFlamDescription)it.next();
                if (selectedWeight > (currentWeight += effectMeta.weight())) continue;
                try {
                    if (effectMeta.action().execute(player)) {
                        property.luck -= effectMeta.cost();
                        Log.debug((String)"Player %s flim-flammed with %s, current luck: %s", (Object[])new Object[]{player, effectMeta.name(), property.luck});
                        if (!effectMeta.isSilent()) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.flim_flammed", new Object[0]));
                        }
                        return;
                    }
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Error during flimflam '%s' execution", (Object[])new Object[]{effectMeta.name()});
                }
                totalWeight -= effectMeta.weight();
                it.remove();
                continue block3;
            }
        }
    }

    public static int getLuck(EntityPlayer player) {
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        return property != null ? property.luck : 0;
    }

    public static int modifyLuck(EntityPlayer player, int amount) {
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        if (property == null) {
            return 0;
        }
        property.luck += amount;
        return property.luck;
    }

    private static boolean canFlimFlam(Luck property) {
        if (property.forceNext) {
            property.forceNext = false;
            property.cooldown = 300;
            return true;
        }
        if (property.luck > 30 || property.cooldown-- > 0) {
            return false;
        }
        property.cooldown = 300;
        double probability = 1.5 * Math.abs(Math.atan((double)property.luck / 250.0) / Math.PI);
        double r = RANDOM.nextDouble();
        return r < probability;
    }

    private static int getFlimFlamToolLevel(EntityPlayer player) {
        return EnchantmentHelper.func_77506_a((Enchantment)OpenBlocks.Enchantments.flimFlam, (ItemStack)player.func_184614_ca());
    }

    private static int getFlimFlamArmorLevel(EntityPlayer player) {
        int sum = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            sum += EnchantmentHelper.func_77506_a((Enchantment)OpenBlocks.Enchantments.flimFlam, (ItemStack)stack);
        }
        return sum;
    }

    private static class CapabilityInjector {
        private CapabilityInjector() {
        }

        @SubscribeEvent
        public void attachCapability(AttachCapabilitiesEvent<Entity> evt) {
            if (evt.getObject() instanceof EntityPlayerMP) {
                evt.addCapability(CAPABILITY_KEY, (ICapabilityProvider)new ICapabilitySerializable<NBTTagInt>(){
                    private final Luck state = new Luck();

                    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == CAPABILITY;
                    }

                    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == CAPABILITY) {
                            return (T)this.state;
                        }
                        return null;
                    }

                    public NBTTagInt serializeNBT() {
                        return new NBTTagInt(this.state.luck);
                    }

                    public void deserializeNBT(NBTTagInt nbt) {
                        this.state.luck = nbt.func_150287_d();
                    }
                });
            }
        }
    }

    private static class Luck {
        public int luck;
        public int cooldown;
        public boolean forceNext;

        private Luck() {
        }
    }
}

