/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import org.lwjgl.opengl.GL11;

public class GhostIngredientDrag<T> {
    private static final Color targetColor = new Color(19, 201, 10, 64);
    private static final Color hoverColor = new Color(76, 201, 25, 128);
    private final IGhostIngredientHandler<?> handler;
    private final List<IGhostIngredientHandler.Target<T>> targets;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    @Nullable
    private final Rectangle origin;

    public GhostIngredientDrag(IGhostIngredientHandler<?> handler, List<IGhostIngredientHandler.Target<T>> targets, IIngredientRenderer<T> ingredientRenderer, T ingredient, @Nullable Rectangle origin) {
        this.handler = handler;
        this.targets = targets;
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.origin = origin;
    }

    public void drawTargets(int mouseX, int mouseY) {
        if (this.handler.shouldHighlightTargets()) {
            List<IGhostIngredientHandler.Target<Object>> targets = this.targets;
            GhostIngredientDrag.drawTargets(mouseX, mouseY, targets);
        }
    }

    public void drawItem(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.origin != null) {
            int originX = this.origin.x + this.origin.width / 2;
            int originY = this.origin.y + this.origin.height / 2;
            int xDist = originX - mouseX;
            int yDist = originY - mouseY;
            float lineWidth = 2.0f;
            if (minecraft.field_71462_r != null) {
                long distanceSq = xDist * xDist + yDist * yDist;
                int screenDim = minecraft.field_71462_r.field_146294_l * minecraft.field_71462_r.field_146295_m;
                float percentOfDim = Math.min(1.0f, (float)distanceSq / (float)screenDim);
                lineWidth = 1.0f + (1.0f - percentOfDim) * 3.0f;
            }
            GL11.glDisable((int)3553);
            GlStateManager.func_179097_i();
            GL11.glLineWidth((float)lineWidth);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            GL11.glBegin((int)1);
            GL11.glColor4f((float)((float)targetColor.getRed() / 255.0f), (float)((float)targetColor.getGreen() / 255.0f), (float)((float)targetColor.getBlue() / 255.0f), (float)((float)targetColor.getAlpha() / 255.0f));
            GL11.glVertex3f((float)mouseX, (float)mouseY, (float)150.0f);
            GL11.glVertex3f((float)originX, (float)originY, (float)150.0f);
            GL11.glEnd();
            GlStateManager.func_179126_j();
            GL11.glEnable((int)3553);
        }
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.field_77023_b += 150.0f;
        this.ingredientRenderer.render(minecraft, mouseX - 8, mouseY - 8, this.ingredient);
        renderItem.field_77023_b -= 150.0f;
    }

    public static void drawTargets(int mouseX, int mouseY, List<IGhostIngredientHandler.Target<Object>> targets) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        for (IGhostIngredientHandler.Target<Object> target : targets) {
            Rectangle area = target.getArea();
            Color color = area.contains(mouseX, mouseY) ? hoverColor : targetColor;
            Gui.func_73734_a((int)area.x, (int)area.y, (int)(area.x + area.width), (int)(area.y + area.height), (int)color.getRGB());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onClick(int mouseX, int mouseY) {
        for (IGhostIngredientHandler.Target<T> target : this.targets) {
            Rectangle area = target.getArea();
            if (!area.contains(mouseX, mouseY)) continue;
            target.accept(this.ingredient);
            this.handler.onComplete();
            return true;
        }
        this.handler.onComplete();
        return false;
    }

    public IIngredientRenderer<T> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    public T getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public Rectangle getOrigin() {
        return this.origin;
    }
}

