/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.runtime.JeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiContainerWrapper
implements IShowsRecipeFocuses {
    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        ItemStack stack;
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (!(guiScreen instanceof GuiContainer)) {
            return null;
        }
        GuiContainer guiContainer = (GuiContainer)guiScreen;
        Slot slotUnderMouse = guiContainer.getSlotUnderMouse();
        if (slotUnderMouse != null && !(stack = slotUnderMouse.func_75211_c()).func_190926_b()) {
            Rectangle slotArea = new Rectangle(slotUnderMouse.field_75223_e, slotUnderMouse.field_75221_f, 16, 16);
            return new ClickedIngredient<ItemStack>(stack, slotArea);
        }
        return this.getAdvancedGuiHandlerIngredientUnderMouse(guiContainer, mouseX, mouseY);
    }

    @Nullable
    private <T extends GuiContainer> IClickedIngredient<?> getAdvancedGuiHandlerIngredientUnderMouse(T guiContainer, int mouseX, int mouseY) {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null) {
            List<IAdvancedGuiHandler<T>> activeAdvancedGuiHandlers = runtime.getActiveAdvancedGuiHandlers(guiContainer);
            for (IAdvancedGuiHandler<T> advancedGuiHandler : activeAdvancedGuiHandlers) {
                Object clicked = advancedGuiHandler.getIngredientUnderMouse(guiContainer, mouseX, mouseY);
                if (clicked == null || !Internal.getIngredientRegistry().isValidIngredient(clicked)) continue;
                Rectangle area = null;
                Slot slotUnderMouse = guiContainer.getSlotUnderMouse();
                if (clicked instanceof ItemStack && slotUnderMouse != null && ItemStack.func_77989_b((ItemStack)slotUnderMouse.func_75211_c(), (ItemStack)((ItemStack)clicked))) {
                    area = new Rectangle(slotUnderMouse.field_75223_e, slotUnderMouse.field_75221_f, 16, 16);
                }
                return new ClickedIngredient<Object>(clicked, area);
            }
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return false;
    }
}

