/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public final class FuelRecipeMaker {
    private FuelRecipeMaker() {
    }

    public static List<FuelRecipe> getFuelRecipes(IIngredientRegistry ingredientRegistry, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        List<ItemStack> fuelStacks = ingredientRegistry.getFuels();
        HashSet<String> oreDictNames = new HashSet<String>();
        ArrayList<FuelRecipe> fuelRecipes = new ArrayList<FuelRecipe>(fuelStacks.size());
        for (ItemStack fuelStack : fuelStacks) {
            if (fuelStack == null) continue;
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)fuelStack);
            if (oreIDs.length > 0) {
                for (int oreID : oreIDs) {
                    String name = OreDictionary.getOreName((int)oreID);
                    if (oreDictNames.contains(name)) continue;
                    oreDictNames.add(name);
                    NonNullList oreDictFuels = OreDictionary.getOres((String)name);
                    List<ItemStack> oreDictFuelsSet = stackHelper.getAllSubtypes((Iterable)oreDictFuels);
                    FuelRecipeMaker.removeNoBurnTime(oreDictFuelsSet);
                    if (oreDictFuels.isEmpty()) continue;
                    ItemStack itemStack = (ItemStack)oreDictFuels.get(0);
                    int burnTime = FuelRecipeMaker.getBurnTime(itemStack);
                    if (burnTime > 0) {
                        fuelRecipes.add(new FuelRecipe(guiHelper, oreDictFuelsSet, burnTime));
                        continue;
                    }
                    String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
                    Log.get().error("Fuel has no burn time ({}): {}", (Object)burnTime, (Object)itemStackInfo);
                }
                continue;
            }
            List<ItemStack> fuels = stackHelper.getSubtypes(fuelStack);
            FuelRecipeMaker.removeNoBurnTime(fuels);
            if (fuels.isEmpty()) continue;
            ItemStack itemStack = fuels.get(0);
            int burnTime = FuelRecipeMaker.getBurnTime(itemStack);
            if (burnTime > 0) {
                fuelRecipes.add(new FuelRecipe(guiHelper, fuels, burnTime));
                continue;
            }
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.get().error("Fuel has no burn time ({}): {}", (Object)burnTime, (Object)itemStackInfo);
        }
        return fuelRecipes;
    }

    private static void removeNoBurnTime(Collection<ItemStack> itemStacks) {
        itemStacks.removeIf(itemStack -> FuelRecipeMaker.getBurnTime(itemStack) == 0);
    }

    private static int getBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack);
    }
}

