/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.IIngredientFilter;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGuiProperties;
import mezz.jei.api.gui.IGuiScreenHandler;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.recipes.RecipeRegistry;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class JeiRuntime
implements IJeiRuntime {
    private final RecipeRegistry recipeRegistry;
    private final IngredientListOverlay ingredientListOverlay;
    private final RecipesGui recipesGui;
    private final IngredientRegistry ingredientRegistry;
    private final List<IAdvancedGuiHandler<?>> advancedGuiHandlers;
    private final Map<Class, IGuiScreenHandler> guiScreenHandlers;
    private final Map<Class, IGhostIngredientHandler> ghostIngredientHandlers;
    private final IngredientFilter ingredientFilter;

    public JeiRuntime(RecipeRegistry recipeRegistry, IngredientListOverlay ingredientListOverlay, RecipesGui recipesGui, IngredientRegistry ingredientRegistry, List<IAdvancedGuiHandler<?>> advancedGuiHandlers, Map<Class, IGuiScreenHandler> guiScreenHandlers, Map<Class, IGhostIngredientHandler> ghostIngredientHandlers, IngredientFilter ingredientFilter) {
        this.recipeRegistry = recipeRegistry;
        this.ingredientListOverlay = ingredientListOverlay;
        this.recipesGui = recipesGui;
        this.ingredientRegistry = ingredientRegistry;
        this.advancedGuiHandlers = advancedGuiHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.ingredientFilter = ingredientFilter;
    }

    public void close() {
        this.recipesGui.close();
    }

    @Override
    public RecipeRegistry getRecipeRegistry() {
        return this.recipeRegistry;
    }

    @Override
    public IngredientListOverlay getItemListOverlay() {
        return this.ingredientListOverlay;
    }

    @Override
    public IIngredientFilter getIngredientFilter() {
        return this.ingredientFilter;
    }

    @Override
    public IngredientListOverlay getIngredientListOverlay() {
        return this.ingredientListOverlay;
    }

    @Override
    public RecipesGui getRecipesGui() {
        return this.recipesGui;
    }

    public IngredientRegistry getIngredientRegistry() {
        return this.ingredientRegistry;
    }

    public <T extends GuiContainer> List<IAdvancedGuiHandler<T>> getActiveAdvancedGuiHandlers(T guiContainer) {
        ArrayList<IAdvancedGuiHandler<T>> activeAdvancedGuiHandler = new ArrayList<IAdvancedGuiHandler<T>>();
        for (IAdvancedGuiHandler<?> advancedGuiHandler : this.advancedGuiHandlers) {
            Class<?> guiContainerClass = advancedGuiHandler.getGuiContainerClass();
            if (!guiContainerClass.isInstance(guiContainer)) continue;
            activeAdvancedGuiHandler.add(advancedGuiHandler);
        }
        return activeAdvancedGuiHandler;
    }

    @Nullable
    public <T extends GuiScreen> IGuiProperties getGuiProperties(@Nullable T guiScreen) {
        if (guiScreen == null) {
            return null;
        }
        IGuiScreenHandler handler = this.guiScreenHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler.apply(guiScreen);
        }
        for (Map.Entry<Class, IGuiScreenHandler> entry : this.guiScreenHandlers.entrySet()) {
            IGuiScreenHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2.apply(guiScreen);
        }
        return null;
    }

    @Nullable
    public <T extends GuiScreen> IGhostIngredientHandler<T> getGhostIngredientHandler(T guiScreen) {
        IGhostIngredientHandler handler = this.ghostIngredientHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler;
        }
        for (Map.Entry<Class, IGhostIngredientHandler> entry : this.ghostIngredientHandlers.entrySet()) {
            IGhostIngredientHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2;
        }
        return null;
    }
}

