/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.IngredientSet;

public class ModIngredientRegistration
implements IModIngredientRegistration {
    private final Map<Class, Collection> allIngredientsMap = new IdentityHashMap<Class, Collection>();
    private final Map<Class, IIngredientHelper> ingredientHelperMap = new IdentityHashMap<Class, IIngredientHelper>();
    private final Map<Class, IIngredientRenderer> ingredientRendererMap = new IdentityHashMap<Class, IIngredientRenderer>();

    @Override
    public <V> void register(Class<V> ingredientClass, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotNull(allIngredients, "allIngredients");
        ErrorUtil.checkNotNull(ingredientHelper, "ingredientHelper");
        ErrorUtil.checkNotNull(ingredientRenderer, "ingredientRenderer");
        this.allIngredientsMap.put(ingredientClass, allIngredients);
        this.ingredientHelperMap.put(ingredientClass, ingredientHelper);
        this.ingredientRendererMap.put(ingredientClass, ingredientRenderer);
    }

    public IngredientRegistry createIngredientRegistry(IModIdHelper modIdHelper) {
        IdentityHashMap<Class, IngredientSet> ingredientsMap = new IdentityHashMap<Class, IngredientSet>();
        for (Map.Entry<Class, Collection> entry : this.allIngredientsMap.entrySet()) {
            Class ingredientClass = entry.getKey();
            Collection ingredients = entry.getValue();
            IIngredientHelper ingredientHelper = this.ingredientHelperMap.get(ingredientClass);
            IngredientSet ingredientSet = IngredientSet.create(ingredientClass, ingredientHelper);
            ingredientSet.addAll(ingredients);
            ingredientsMap.put(ingredientClass, ingredientSet);
        }
        return new IngredientRegistry(modIdHelper, ingredientsMap, (ImmutableMap<Class, IIngredientHelper>)ImmutableMap.copyOf(this.ingredientHelperMap), (ImmutableMap<Class, IIngredientRenderer>)ImmutableMap.copyOf(this.ingredientRendererMap));
    }
}

