/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.enchantment.handler;

import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentLumberingHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void register(BlockEvent.BreakEvent event) {
        if (!Config.getInstance().enableEnchLumbering) {
            return;
        }
        if (event.getState() == null || event.getWorld() == null || event.getPlayer() == null || event.getPlayer().func_184614_ca().func_190926_b()) {
            return;
        }
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().lumbering, (ItemStack)player.func_184614_ca()) > 0) {
            this.chopTree(world, player, event.getPos());
        }
    }

    private void chopTree(World world, EntityPlayer player, BlockPos pos) {
        if (player.func_70093_af() && world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos)) {
            for (int xPos = pos.func_177958_n() - 5; xPos <= pos.func_177958_n() + 5; ++xPos) {
                for (int yPos = pos.func_177956_o() - 1; yPos <= pos.func_177956_o() + 32; ++yPos) {
                    for (int zPos = pos.func_177952_p() - 5; zPos <= pos.func_177952_p() + 5; ++zPos) {
                        BlockPos newPos = new BlockPos(xPos, yPos, zPos);
                        if (!world.func_180495_p(newPos).func_177230_c().isWood((IBlockAccess)world, newPos)) continue;
                        if (player.func_184614_ca().func_96631_a(1, world.field_73012_v, null)) {
                            return;
                        }
                        this.breakBlock(world, player, newPos);
                    }
                }
            }
        }
    }

    private void breakBlock(World world, EntityPlayer player, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        IBlockState state = world.func_180495_p(pos);
        block.func_176208_a(world, pos, state, player);
        if (block.removedByPlayer(state, world, pos, player, true)) {
            block.func_176206_d(world, pos, state);
            block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        world.func_184133_a(null, pos, block.getSoundType(state, world, pos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 0.25f, 0.8f);
    }
}

