/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.util;

import com.oitsjustjose.vtweaks.util.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuideNotifier {
    @SubscribeEvent
    public void registerEvent(EntityJoinWorldEvent event) {
        EntityPlayer player;
        NBTTagCompound persistTag;
        if (!Config.getInstance().enableGuideNotifier) {
            return;
        }
        Entity entity = event.getEntity();
        String SHOWN_LINK = "shownVTweaksLink";
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityPlayer && !(persistTag = this.getPlayerPersistTag(player = (EntityPlayer)entity, "vtweaks")).func_74767_n("shownVTweaksLink") && !entity.field_70170_p.field_72995_K) {
            Style style = new Style();
            String wikiURL = "https://oitsjustjose.github.io/Mods/vtweaks.html";
            style.func_150238_a(TextFormatting.BLUE);
            style.func_150227_a(Boolean.valueOf(true));
            style.func_150228_d(Boolean.valueOf(true));
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, wikiURL));
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("V-Tweaks Wiki")));
            player.func_145747_a((ITextComponent)new TextComponentString("Welcome! Seems like this is your first time running V-Tweaks in this world! Here's a link to an online wiki if you're interested, keep in mind some features may be disabled!"));
            player.func_145747_a(new TextComponentString("V-Tweaks Online Wiki").func_150255_a(style));
            persistTag.func_74757_a("shownVTweaksLink", true);
        }
    }

    NBTTagCompound getPlayerPersistTag(EntityPlayer player, String modid) {
        NBTTagCompound tag = player.getEntityData();
        NBTTagCompound persistTag = null;
        if (tag.func_74764_b("PlayerPersisted")) {
            persistTag = tag.func_74775_l("PlayerPersisted");
        } else {
            persistTag = new NBTTagCompound();
            tag.func_74782_a("PlayerPersisted", (NBTBase)persistTag);
        }
        NBTTagCompound modTag = null;
        if (persistTag.func_74764_b(modid)) {
            modTag = persistTag.func_74775_l(modid);
        } else {
            modTag = new NBTTagCompound();
            persistTag.func_74782_a(modid, (NBTBase)modTag);
        }
        return modTag;
    }
}

