/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.mcft.copy.backpacks.block.entity.TileEntityBackpack;
import net.mcft.copy.backpacks.container.SlotArmorBackpack;
import net.mcft.copy.backpacks.item.DyeWashingHandler;
import net.mcft.copy.backpacks.misc.BackpackCapability;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.mcft.copy.backpacks.misc.util.WorldUtils;
import net.mcft.copy.backpacks.network.MessageBackpackUpdate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ProxyCommon {
    private boolean cancelOffHand = false;

    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)WearableBackpacks.CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)WearableBackpacks.CONTENT);
        MinecraftForge.EVENT_BUS.register((Object)new DyeWashingHandler());
        CapabilityManager.INSTANCE.register(IBackpack.class, (Capability.IStorage)new BackpackCapability.Storage(), BackpackCapability.class);
    }

    public void init() {
    }

    public void initBackpackLayers() {
    }

    @SubscribeEvent
    public void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        if (!BackpackRegistry.canEntityWearBackpacks((Entity)event.getObject())) {
            return;
        }
        event.addCapability(BackpackCapability.IDENTIFIER, (ICapabilityProvider)new BackpackCapability.Provider((EntityLivingBase)event.getObject()));
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.sendBackpackStack((Entity)event.player, event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendBackpackStack((Entity)event.player, event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendBackpackStack((Entity)event.player, event.player);
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        this.sendBackpackStack(event.getTarget(), event.getEntityPlayer());
    }

    private void sendBackpackStack(Entity carrier, EntityPlayer player) {
        BackpackCapability backpack = (BackpackCapability)BackpackHelper.getBackpack(carrier);
        if (backpack != null) {
            WearableBackpacks.CHANNEL.sendTo(MessageBackpackUpdate.stack(carrier, backpack.stack), player);
        }
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!(event.isSpawner() ? WearableBackpacks.CONFIG.entity.spawnFromSpawners : WearableBackpacks.CONFIG.entity.spawnNaturally).get().booleanValue()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        for (BackpackRegistry.BackpackEntry entry : BackpackRegistry.getBackpackEntries(entity.getClass())) {
            if (entry.chance == 0 || entity.field_70170_p.field_73012_v.nextDouble() > 1.0 / (double)entry.chance) continue;
            BackpackCapability backpack = (BackpackCapability)entity.getCapability(IBackpack.CAPABILITY, null);
            backpack.spawnWith = entry;
            break;
        }
    }

    private void onSpawnedWith(EntityLivingBase entity, BackpackCapability backpack, BackpackRegistry.BackpackEntry entry) {
        ItemStack armor;
        ItemStack stack = new ItemStack(entry.getBackpackItem());
        if (entry.colorRange != null) {
            NbtUtils.set(stack, Integer.valueOf(entry.colorRange.getRandom()), "display", "color");
        }
        int maxDamage = stack.func_77958_k();
        int damage = maxDamage / 4 + (maxDamage / 2 > 0 ? entity.field_70170_p.field_73012_v.nextInt(maxDamage / 2) : 0);
        stack.func_77964_b(damage);
        if (BackpackHelper.equipAsChestArmor && (armor = entity.func_184582_a(EntityEquipmentSlot.CHEST)) != null && armor.func_77948_v()) {
            NBTTagList enchList = armor.func_77986_q();
            for (int i = 0; i < enchList.func_74745_c(); ++i) {
                NBTTagCompound enchTag = enchList.func_150305_b(i);
                Enchantment enchantment = Enchantment.func_185262_c((int)enchTag.func_74765_d("id"));
                if (enchantment.func_92089_a(stack)) continue;
                enchList.func_74744_a(i--);
            }
            if (enchList.func_74745_c() > 0) {
                NbtUtils.set(stack, (NBTBase)enchList, "ench");
            }
        }
        IBackpackType type = (IBackpackType)entry.getBackpackItem();
        IBackpackData data = type.createBackpackData(stack);
        BackpackHelper.setEquippedBackpack(entity, stack, data);
        type.onSpawnedWith(entity, backpack, entry.lootTable);
        backpack.spawnWith = null;
        backpack.mayDespawn = true;
    }

    @SubscribeEvent
    public void onPlayerInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        if (this.cancelOffHand) {
            this.cancelOffHand = false;
            if (event.getHand() == EnumHand.OFF_HAND) {
                event.setCanceled(true);
                return;
            }
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (!player.func_70093_af() || event.getHand() != EnumHand.MAIN_HAND || !player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return;
        }
        IBackpack backpack = BackpackHelper.getBackpack((Entity)player);
        if (backpack == null) {
            return;
        }
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)backpack.getStack());
        if (backpack.getStack().func_179546_a(player, world, event.getPos(), EnumHand.MAIN_HAND, event.getFace(), 0.5f, 0.5f, 0.5f) == EnumActionResult.SUCCESS) {
            player.func_184609_a(EnumHand.MAIN_HAND);
            event.setCanceled(true);
            this.cancelOffHand = true;
        } else {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        IBackpackData data;
        if (!WearableBackpacks.CONFIG.enableEquippedInteraction.get().booleanValue() || !(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EntityLivingBase target = (EntityLivingBase)event.getTarget();
        BackpackCapability backpack = (BackpackCapability)target.getCapability(IBackpack.CAPABILITY, null);
        if (backpack == null || !BackpackHelper.canInteractWithEquippedBackpack(player, target)) {
            return;
        }
        IBackpackType type = backpack.getType();
        if (type == null) {
            WearableBackpacks.LOG.error("Backpack type was null when accessing equipped backpack");
            return;
        }
        if (!player.field_70170_p.field_72995_K && backpack.getData() == null && (data = type.createBackpackData(backpack.getStack())) != null) {
            WearableBackpacks.LOG.error("Backpack data was null when accessing equipped backpack");
            backpack.setData(data);
        }
        type.onEquippedInteract(player, target, backpack);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        boolean hasBackpack;
        EntityLivingBase entity = event.getEntityLiving();
        BackpackCapability backpack = (BackpackCapability)entity.getCapability(IBackpack.CAPABILITY, null);
        if (backpack == null) {
            return;
        }
        if (backpack.spawnWith != null) {
            this.onSpawnedWith(entity, backpack, backpack.spawnWith);
        }
        boolean bl = hasBackpack = !backpack.getStack().func_190926_b();
        if (backpack.isChestArmor()) {
            if (entity instanceof EntityPlayer) {
                SlotArmorBackpack.replace((EntityPlayer)entity);
            }
            if (!hasBackpack) {
                backpack.getType().onFaultyRemoval(entity, backpack);
                backpack.setStack(ItemStack.field_190927_a);
                return;
            }
        } else if (!hasBackpack) {
            return;
        }
        backpack.getType().onEquippedTick(entity, backpack);
        if (entity.field_70170_p.field_72995_K) {
            BackpackHelper.updateLidTicks(backpack, entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BackpackCapability backpack = (BackpackCapability)entity.getCapability(IBackpack.CAPABILITY, null);
        if (backpack == null || backpack.getStack().func_190926_b()) {
            return;
        }
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        boolean keepInventory = world.func_82736_K().func_82766_b("keepInventory");
        if (player != null && keepInventory) {
            return;
        }
        if (WearableBackpacks.CONFIG.dropAsBlockOnDeath.get().booleanValue()) {
            ArrayList<BlockCoord> coords = new ArrayList<BlockCoord>();
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    coords.add(new BlockCoord((Entity)entity, x, z));
                }
            }
            Collections.sort(coords, new Comparator<BlockCoord>(){

                @Override
                public int compare(BlockCoord o1, BlockCoord o2) {
                    if (o1.distance < o2.distance) {
                        return -1;
                    }
                    if (o1.distance > o2.distance) {
                        return 1;
                    }
                    return 0;
                }
            });
            while (!coords.isEmpty()) {
                Iterator iter = coords.iterator();
                while (iter.hasNext()) {
                    BlockCoord coord = (BlockCoord)((Object)iter.next());
                    if (BackpackHelper.placeBackpack(world, (BlockPos)coord, backpack.getStack(), entity, true)) {
                        ((TileEntityBackpack)world.func_175625_s((BlockPos)coord)).setPlacedOnDeath(backpack.mayDespawn);
                        return;
                    }
                    boolean replacable = world.func_180495_p((BlockPos)coord).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)coord);
                    coord.func_177982_a(0, replacable ? -1 : 1, 0);
                    coord.moved = coord.moved + (replacable ? 1 : 5);
                    if (coord.func_177956_o() > 0 && coord.func_177956_o() <= world.func_72800_K() && !((double)coord.moved > 24.0 - coord.distance * 4.0)) continue;
                    iter.remove();
                }
            }
        }
        backpack.getType().onDeath(entity, backpack);
        if (!backpack.getStack().func_190926_b()) {
            WorldUtils.dropStackFromEntity((Entity)entity, backpack.getStack(), 4.0f);
        }
        BackpackHelper.setEquippedBackpack(entity, ItemStack.field_190927_a, null);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        IBackpack originalBackpack = BackpackHelper.getBackpack((Entity)event.getOriginal());
        if (originalBackpack == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        IBackpack clonedBackpack = (IBackpack)player.getCapability(IBackpack.CAPABILITY, null);
        clonedBackpack.setStack(originalBackpack.getStack());
        clonedBackpack.setData(originalBackpack.getData());
    }

    private static class BlockCoord
    extends BlockPos.MutableBlockPos {
        public double distance;
        public int moved = 0;

        public BlockCoord(Entity entity, int x, int z) {
            super((int)entity.field_70165_t + x, (int)entity.field_70163_u, (int)entity.field_70161_v + z);
            this.distance = Math.sqrt(Math.pow((double)this.func_177958_n() + 0.5 - entity.field_70165_t, 2.0) + Math.pow((double)this.func_177956_o() + 0.5 - entity.field_70163_u, 2.0) + Math.pow((double)this.func_177952_p() + 0.5 - entity.field_70161_v, 2.0));
        }
    }
}

