/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.client.gui.ElementInfo;
import net.mcft.copy.backpacks.client.gui.GuiContainer;
import net.mcft.copy.backpacks.client.gui.GuiContext;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiContainerScreen
extends GuiScreen {
    private int _lastMouseX = -1;
    private int _lastMouseY = -1;
    public final GuiContext context = new GuiContext();
    public final GuiContainer container = new GuiContainer(this.context);
    private GuiElementBase _tooltipElement = null;
    private long _tooltipTime = 0L;

    public GuiContainerScreen() {
        this.container.setFill();
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.context.setScreen(this);
        super.func_146280_a(mc, width, height);
        this.container.setSize(width, height);
    }

    public void func_146281_b() {
        this.context.setScreen(null);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == GuiElementBase.MouseButton.LEFT) {
            this.context.setFocused(null);
        }
        this.container.onMouseDown(mouseButton, mouseX, mouseY);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int scroll = Integer.signum(Mouse.getEventDWheel());
        if (scroll != 0) {
            this.container.onMouseScroll(scroll, mouseX, mouseY);
        }
    }

    public void func_73876_c() {
        GuiElementBase tooltipElement;
        int mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (mouseX != this._lastMouseX || mouseY != this._lastMouseY) {
            GuiElementBase pressed = this.context.getPressed();
            if (pressed != null) {
                ElementInfo info2 = ElementInfo.getElementHierarchy(pressed).getFirst();
                pressed.onMouseMove(mouseX - info2.globalX, mouseY - info2.globalY);
            } else if (this.container.contains(mouseX, mouseY)) {
                this.container.onMouseMove(mouseX, mouseY);
            }
            this._lastMouseX = mouseX;
            this._lastMouseY = mouseY;
        }
        if ((tooltipElement = (GuiElementBase)new ElementInfo(this.container).getElementsAt(mouseX, mouseY).map(info -> info.element).filter(element -> element.hasTooltip()).reduce((first, second) -> second).orElse(null)) != this._tooltipElement) {
            this._tooltipTime = Minecraft.func_71386_F();
        }
        this._tooltipElement = tooltipElement;
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != GuiElementBase.MouseButton.LEFT) {
            return;
        }
        GuiElementBase pressed = this.context.getPressed();
        if (pressed == null) {
            return;
        }
        pressed.onMouseUp(mouseButton, mouseX, mouseY);
        this.context.setPressed(null);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        GuiElementBase focused;
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 61) {
            if (GuiContainerScreen.func_146272_n()) {
                GuiContext.DEBUG = !GuiContext.DEBUG;
            } else if (GuiContext.DEBUG) {
                boolean bl = GuiContext.DEBUG_TEXT = !GuiContext.DEBUG_TEXT;
            }
        }
        if ((focused = this.context.getFocused()) != null) {
            focused.onKey(keyCode, typedChar);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.container.draw(mouseX, mouseY, partialTicks);
        if (this._tooltipElement != null && Minecraft.func_71386_F() >= this._tooltipTime + (long)this._tooltipElement.getTooltipDelay()) {
            this._tooltipElement.drawTooltip(mouseX, mouseY, this.field_146294_l, this.field_146295_m, partialTicks);
        }
        if (GuiContext.DEBUG) {
            this.drawDebugInfo(mouseX, mouseY, partialTicks);
        }
    }

    private void drawDebugInfo(int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRenderer = GuiElementBase.getFontRenderer();
        List hierarchy = new ElementInfo(this.container).getElementsAt(mouseX, mouseY).collect(Collectors.toList());
        ElementInfo last = (ElementInfo)hierarchy.get(hierarchy.size() - 1);
        List children = last.getChildElements().collect(Collectors.toList());
        GuiElementBase.enableBlendAlphaStuffs();
        GuiElementBase.setRenderColorARGB(0x60FFFF00);
        for (ElementInfo info : hierarchy) {
            if (info == last) continue;
            GuiElementBase.drawOutline(info.globalX - 1, info.globalY - 1, info.width + 2, info.height + 2);
        }
        GuiElementBase.setRenderColorARGB(-1610547456);
        GuiElementBase.drawOutline(last.globalX - 1, last.globalY - 1, last.width + 2, last.height + 2);
        GuiElementBase.setRenderColorARGB(0x3000FF00);
        GuiElementBase.drawRect(last.globalX, last.globalY, last.width, last.height);
        if (last.element instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)last.element;
            int x = last.globalX;
            int y = last.globalY;
            int w = last.width;
            int h = last.height;
            int padLeft = container.getPaddingLeft();
            int padRight = container.getPaddingRight();
            int padTop = container.getPaddingTop();
            int padBottom = container.getPaddingBottom();
            GuiElementBase.setRenderColorARGB(-2147483393);
            GuiElementBase.drawRect(x, y, padLeft, h);
            GuiElementBase.drawRect(x + w - padRight, y, padRight, h);
            GuiElementBase.drawRect(x + padLeft, y, w, padTop);
            GuiElementBase.drawRect(x + padLeft, y + h - padBottom, w, padBottom);
        }
        if (!children.isEmpty()) {
            GuiElementBase.setRenderColorARGB(-2130771968);
            for (ElementInfo child : children) {
                GuiElementBase.drawOutline(child.globalX - 1, child.globalY - 1, child.width + 2, child.height + 2);
            }
        }
        GuiElementBase.disableBlendAlphaStuffs();
        if (!GuiContext.DEBUG_TEXT) {
            return;
        }
        int textY = 4;
        for (ElementInfo info : hierarchy) {
            fontRenderer.func_175063_a(info.toString(), 4.0f, (float)textY, 0xFFFFFF);
            textY += GuiElementBase.LINE_HEIGHT;
        }
        if (!children.isEmpty()) {
            fontRenderer.func_175063_a("Children:", 4.0f, (float)(textY += GuiElementBase.LINE_HEIGHT), 0xFFFFFF);
            textY += GuiElementBase.LINE_HEIGHT;
            for (ElementInfo child : children) {
                fontRenderer.func_175063_a(child.toString(), 10.0f, (float)textY, 0xFFFFFF);
                textY += GuiElementBase.LINE_HEIGHT;
            }
        }
    }
}

