/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.client.gui.GuiContext;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.config.BaseConfigScreen;
import net.mcft.copy.backpacks.client.gui.config.EntryCategory;
import net.mcft.copy.backpacks.client.gui.config.EntrySetting;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.mcft.copy.backpacks.client.gui.test.GuiTestScreen;
import net.mcft.copy.backpacks.config.Setting;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BackpacksConfigScreen
extends BaseConfigScreen {
    private final GuiButton _buttonTest = new GuiButton(18, 18, "T");

    public BackpacksConfigScreen(GuiScreen parentScreen) {
        this(parentScreen, (String)null);
        for (Setting<?> setting : WearableBackpacks.CONFIG.getSettingsGeneral()) {
            this.addEntry(BackpacksConfigScreen.CreateEntryFromSetting(setting));
        }
        for (String cat : WearableBackpacks.CONFIG.getCategories()) {
            this.addEntry(new EntryCategory(this, cat));
        }
    }

    public BackpacksConfigScreen(GuiScreen parentScreen, EntryCategory category) {
        this(parentScreen, category.getLanguageKey());
        for (Setting<?> setting : WearableBackpacks.CONFIG.getSettings(category.category)) {
            this.addEntry(BackpacksConfigScreen.CreateEntryFromSetting(setting));
        }
    }

    public BackpacksConfigScreen(GuiScreen parentScreen, String subtitle) {
        super(parentScreen, "Wearable Backpacks", subtitle);
        this._buttonTest.setRight(3);
        this._buttonTest.setTop(3);
        this._buttonTest.setAction(() -> GuiElementBase.display(new GuiTestScreen(this)));
        this.container.add(this._buttonTest);
        this.layoutButtons.addFixed(this.buttonDone);
        this.layoutButtons.addFixed(this.buttonUndo);
        this.layoutButtons.addFixed(this.buttonReset);
    }

    public static <T> GuiElementBase CreateEntryFromSetting(Setting<T> setting) {
        String entryClassName = setting.getConfigEntryClass();
        if (entryClassName == null) {
            throw new RuntimeException("Setting '" + setting.getFullName() + "' has no entry class defined");
        }
        try {
            Class<?> entryClass = Class.forName(entryClassName);
            if (!GuiElementBase.class.isAssignableFrom(entryClass)) {
                throw new Exception("Not a subclass of GuiElementBase");
            }
            if (IConfigValue.class.isAssignableFrom(entryClass)) {
                return new EntrySetting<T>(setting, (IConfigValue)entryClass.newInstance());
            }
            Constructor constructor = Arrays.stream(entryClass.getConstructors()).filter(c -> c.getParameterCount() == 1 && c.getParameterTypes()[0].isAssignableFrom(setting.getClass())).findFirst().orElseThrow(() -> new Exception("No compatible constructor found"));
            return (GuiElementBase)constructor.newInstance(setting);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while instanciating setting entry for '" + setting.getFullName() + "' (entry class '" + entryClassName + "')", ex);
        }
    }

    @Override
    protected void doneClicked() {
        GuiScreen nextScreen = this.parentScreen;
        if (!(this.parentScreen instanceof BackpacksConfigScreen)) {
            if (this.applyChanges() == Setting.ChangeRequiredAction.RestartMinecraft) {
                nextScreen = new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage");
            }
            WearableBackpacks.CONFIG.save();
        }
        GuiElementBase.display(nextScreen);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this._buttonTest.setVisible(GuiContext.DEBUG);
        this.buttonDone.setEnabled(this.isValid());
        this.buttonUndo.setEnabled(this.isChanged());
        this.buttonReset.setEnabled(!this.isDefault());
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

