/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.client.gui.GuiContainer;
import net.mcft.copy.backpacks.client.gui.GuiLabel;
import net.mcft.copy.backpacks.client.gui.config.BaseEntryList;
import net.mcft.copy.backpacks.client.gui.config.custom.ScreenEntityEntry;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.Status;
import net.mcft.copy.backpacks.config.custom.SettingListEntities;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntryListEntities
extends BaseEntryList<BackpackRegistry.BackpackEntityEntry> {
    public static final Status STATUS_NOT_FOUND = Status.WARN("entity", "entityNotFound", new Object[0]);
    private final SettingListEntities _setting;

    public EntryListEntities(SettingListEntities setting) {
        super(260, BackpackRegistry.getDefaultEntityEntries(), (List)setting.getOwn());
        this._setting = setting;
        GuiContainer entryLabel = new GuiContainer();
        entryLabel.setFillHorizontal();
        entryLabel.setHeight(18);
        GuiLabel label = new GuiLabel(I18n.func_135052_a((String)"config.wearablebackpacks.entity.list", (Object[])new Object[0]));
        label.setCenteredHorizontal();
        label.setBottom(2);
        entryLabel.add(label);
        this.insertFixed(0, entryLabel);
    }

    @Override
    public void setValue(List<BackpackRegistry.BackpackEntityEntry> value) {
        ArrayList<BackpackRegistry.BackpackEntityEntry> entityEntries = new ArrayList<BackpackRegistry.BackpackEntityEntry>();
        BackpackRegistry.mergeEntityEntriesWithDefault(entityEntries, value);
        super.setValue(entityEntries);
    }

    @Override
    protected BaseEntryList.Entry<BackpackRegistry.BackpackEntityEntry> createListEntry() {
        return new Entry(this);
    }

    @Override
    protected void addButtonPressed() {
        EntryListEntities.display(new ScreenEntityEntry(this, Optional.empty()));
    }

    public static Optional<EntityEntry> getEntityEntry(String entityID) {
        return Optional.ofNullable(ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityID))).filter(entry -> EntityLivingBase.class.isAssignableFrom(entry.getEntityClass()));
    }

    public static String getEntityEntryName(Optional<EntityEntry> entry, String entityID) {
        return entry.map(EntityEntry::getName).map(s -> "[" + s + "]").orElse("\"" + entityID + "\"");
    }

    @Override
    public Setting.ChangeRequiredAction applyChanges() {
        if (!this.isChanged()) {
            return Setting.ChangeRequiredAction.None;
        }
        this._setting.set(this.getValue());
        if (!this._setting.requiresMinecraftRestart()) {
            this._setting.update();
        }
        return this._setting.getChangeRequiredAction();
    }

    public static class Entry
    extends BaseEntryList.Entry<BackpackRegistry.BackpackEntityEntry> {
        public final GuiLabel labelName = new GuiLabel(0, "", GuiLabel.TextAlign.CENTER);
        public final GuiButton buttonEdit;
        private BackpackRegistry.BackpackEntityEntry _value;
        private boolean _knownEntity;

        public Entry(EntryListEntities owningList) {
            super(owningList);
            this.labelName.setCenteredVertical();
            this.buttonEdit = new GuiButton(100, 18);
            this.buttonEdit.setAction(() -> Entry.display(new ScreenEntityEntry(owningList, Optional.of(this))));
            this.addFixed(this.buttonMove);
            this.addWeighted(this.labelName);
            this.addFixed(this.buttonEdit);
            this.addFixed(this.buttonRemove);
        }

        @Override
        public BackpackRegistry.BackpackEntityEntry getValue() {
            return this._value;
        }

        @Override
        public void setValue(BackpackRegistry.BackpackEntityEntry value) {
            this._value = value;
            Optional<EntityEntry> entry = EntryListEntities.getEntityEntry(value.entityID);
            this._knownEntity = entry.isPresent();
            Status.Severity severity = Status.getSeverity(this.getStatus());
            boolean isFine = severity == Status.Severity.FINE;
            int numEntries = value.getEntries().size();
            String entriesTextKey = "config.wearablebackpacks.entity.entry";
            String entriesText = I18n.func_135052_a((String)(entriesTextKey + "." + numEntries), (Object[])new Object[0]);
            if (entriesText.equals(entriesTextKey + "." + numEntries)) {
                entriesText = I18n.func_135052_a((String)entriesTextKey, (Object[])new Object[]{numEntries});
            }
            this.buttonMove.setEnabled(!value.isDefault);
            this.buttonRemove.setEnabled(!value.isDefault);
            this.labelName.setText(EntryListEntities.getEntityEntryName(entry, value.entityID));
            this.labelName.setColor(value.isDefault ? GuiUtils.getColorCode((char)'8', (boolean)true) : (isFine ? GuiUtils.getColorCode((char)'7', (boolean)true) : severity.foregroundColor));
            this.buttonEdit.setText(entriesText);
            if (!this._knownEntity) {
                this.buttonEdit.setTextColor(Status.Severity.WARN.foregroundColor);
            } else {
                this.buttonEdit.unsetTextColor();
            }
        }

        @Override
        public List<Status> getStatus() {
            return this._knownEntity ? Collections.emptyList() : Arrays.asList(STATUS_NOT_FOUND);
        }
    }
}

