/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.config.Configuration;

public class SettingListEntities
extends Setting<List<BackpackRegistry.BackpackEntityEntry>> {
    public static final String TAG_ENTITY_ID = "id";
    public static final String TAG_RENDER_OPTIONS = "render";
    public static final String TAG_ENTRIES = "entries";
    public static final String TAG_TRANSLATE = "translate";
    public static final String TAG_ROTATE = "rotate";
    public static final String TAG_SCALE = "scale";
    private static final String SEPERATOR = ",";
    private static final String ID_SEPERATOR = "=";
    private static final String COLOR_SEPERATOR = "~";
    private static final String COLOR_NULL = "DEFAULT";

    public SettingListEntities() {
        super(Collections.emptyList());
        this.setConfigEntryClass("net.mcft.copy.backpacks.client.gui.config.custom.EntryListEntities");
        this.setSynced();
    }

    @Override
    protected void loadFromConfiguration(Configuration config) {
        this.set(BackpackRegistry.mergeEntityEntriesWithDefault(config.getCategoryNames().stream().filter(name -> name.startsWith(this.getCategory() + ".")).sorted(Comparator.comparingInt(category -> config.get(category, "index", Integer.MAX_VALUE).getInt())).map(category -> SettingListEntities.loadEntity(config, category)).collect(Collectors.toList())));
    }

    @Override
    protected void saveToConfiguration(Configuration config) {
        config.getCategoryNames().stream().filter(name -> name.startsWith(this.getCategory() + ".")).forEach(category -> config.removeCategory(config.getCategory(category)));
        int index = 0;
        for (BackpackRegistry.BackpackEntityEntry entity : (List)this.getOwn()) {
            String category2 = this.getCategory() + "." + entity.entityID;
            config.setCategoryPropertyOrder(category2, Arrays.asList("index", TAG_TRANSLATE, TAG_ROTATE, TAG_SCALE, TAG_ENTRIES));
            config.get(category2, "index", 0).set(index++);
            SettingListEntities.saveEntity(config, category2, entity);
        }
    }

    @Override
    public List<BackpackRegistry.BackpackEntityEntry> read(NBTBase tag) {
        return NbtUtils.stream((NBTTagList)tag).map(NBTTagCompound.class::cast).map(SettingListEntities::deserializeEntity).collect(Collectors.toList());
    }

    @Override
    public NBTBase write(List<BackpackRegistry.BackpackEntityEntry> value) {
        return (NBTBase)value.stream().map(SettingListEntities::serializeEntity).collect(NbtUtils.toList());
    }

    @Override
    public void update() {
        BackpackRegistry.updateEntityEntries((List)this.get());
        WearableBackpacks.PROXY.initBackpackLayers();
    }

    private static void saveEntity(Configuration config, String category, BackpackRegistry.BackpackEntityEntry value) {
        SettingListEntities.saveRenderOptions(config, category, value.renderOptions);
        config.get(category, TAG_ENTRIES, new String[0]).set((String[])value.getEntries().stream().map(SettingListEntities::toString).toArray(String[]::new));
    }

    private static BackpackRegistry.BackpackEntityEntry loadEntity(Configuration config, String category) {
        return new BackpackRegistry.BackpackEntityEntry(category.split("\\.", 2)[1], SettingListEntities.loadRenderOptions(config, category), Arrays.stream(config.get(category, TAG_ENTRIES, new String[0]).getStringList()).map(SettingListEntities::parseBackpack).collect(Collectors.toList()), false);
    }

    private static NBTTagCompound serializeEntity(BackpackRegistry.BackpackEntityEntry value) {
        return NbtUtils.createCompound(TAG_ENTITY_ID, value.entityID, TAG_RENDER_OPTIONS, SettingListEntities.serializeRenderOptions(value.renderOptions));
    }

    private static BackpackRegistry.BackpackEntityEntry deserializeEntity(NBTTagCompound nbt) {
        return new BackpackRegistry.BackpackEntityEntry(nbt.func_74779_i(TAG_ENTITY_ID), SettingListEntities.deserializeRenderOptions(nbt.func_74775_l(TAG_RENDER_OPTIONS)), Collections.emptyList(), false);
    }

    private static void saveRenderOptions(Configuration config, String category, BackpackRegistry.RenderOptions value) {
        config.get(category, TAG_TRANSLATE, new double[3]).set(new double[]{value.y, value.z});
        config.get(category, TAG_ROTATE, 0.0).set(value.rotate);
        config.get(category, TAG_SCALE, 0.0).set(value.scale);
    }

    private static BackpackRegistry.RenderOptions loadRenderOptions(Configuration config, String category) {
        double[] translate = config.get(category, TAG_TRANSLATE, new double[2]).getDoubleList();
        return new BackpackRegistry.RenderOptions(translate[0], translate[1], config.get(category, TAG_ROTATE, 0.0).getDouble(), config.get(category, TAG_SCALE, 0.0).getDouble());
    }

    private static NBTTagCompound serializeRenderOptions(BackpackRegistry.RenderOptions value) {
        return NbtUtils.createCompound(TAG_TRANSLATE, NbtUtils.createList(value.y, value.z), TAG_ROTATE, value.rotate, TAG_SCALE, value.scale);
    }

    private static BackpackRegistry.RenderOptions deserializeRenderOptions(NBTTagCompound nbt) {
        NBTTagList translate = nbt.func_150295_c(TAG_TRANSLATE, 6);
        return new BackpackRegistry.RenderOptions(translate.func_150309_d(0), translate.func_150309_d(1), nbt.func_74769_h(TAG_ROTATE), nbt.func_74769_h(TAG_SCALE));
    }

    private static BackpackRegistry.BackpackEntry parseBackpack(String str) {
        String[] values;
        String id = null;
        if (str.indexOf(61) >= 0) {
            values = str.split("\\=", 2);
            id = values[0].trim();
            str = values[1];
        }
        if ((values = str.split("\\,")).length != 4) {
            throw new IllegalArgumentException("Expected 4 parts for backpack entry, got " + values.length);
        }
        int chance = Integer.parseInt(values[0].trim());
        String backpack = values[1].trim();
        String lootTable = values[2].trim();
        BackpackRegistry.ColorRange color = SettingListEntities.parseColorRange(values[3].trim());
        if (chance < 0) {
            throw new IllegalArgumentException("Chance is negative");
        }
        return new BackpackRegistry.BackpackEntry(id, backpack, chance, lootTable, color, false);
    }

    private static String toString(BackpackRegistry.BackpackEntry value) {
        String str = value.chance + SEPERATOR + " " + value.backpack + SEPERATOR + " " + value.lootTable + SEPERATOR + " " + SettingListEntities.toString(value.colorRange);
        return value.id != null ? value.id + " " + ID_SEPERATOR + " " + str : str;
    }

    private static BackpackRegistry.ColorRange parseColorRange(String str) {
        if (COLOR_NULL.equalsIgnoreCase(str)) {
            return null;
        }
        String[] minMax = str.split("\\~", 2);
        if (minMax.length != 2) {
            throw new IllegalArgumentException("Expected 2 parts for color range, got " + minMax.length);
        }
        String min = minMax[0].trim();
        String max = minMax[1].trim();
        if (min.length() != 7 || min.charAt(0) != '#' || max.length() != 7 || max.charAt(0) != '#') {
            throw new IllegalArgumentException("Colors in the color range are not in the format #RRGGBB");
        }
        return new BackpackRegistry.ColorRange(Integer.parseInt(min.substring(1), 16), Integer.parseInt(max.substring(1), 16));
    }

    private static String toString(BackpackRegistry.ColorRange colorRange) {
        return colorRange != null ? String.format("#%06X %s #%06X", colorRange.min, COLOR_SEPERATOR, colorRange.max) : COLOR_NULL;
    }
}

