/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config.custom;

import net.mcft.copy.backpacks.config.SettingDouble;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class SettingPercent
extends SettingDouble {
    public SettingPercent(double defaultValue) {
        super(defaultValue);
        this.setValidRange(0.0, 1.0);
        this.setConfigEntryClass("net.mcft.copy.backpacks.client.gui.config.EntrySlider$Percentage");
    }

    @Override
    protected Property getPropertyFromConfig(Configuration config) {
        return config.get(this.getCategory(), this.getName(), String.valueOf(this.getDefault()), this.getComment(), Property.Type.STRING);
    }

    @Override
    public Double parse(String str) {
        boolean isPercent = false;
        if (str.endsWith("%")) {
            isPercent = true;
            str = str.substring(0, str.length() - 1);
        }
        double d = Double.parseDouble(str);
        if (isPercent) {
            d /= 100.0;
        }
        if (d < this.getMinValue() || d > this.getMaxValue()) {
            throw new IllegalArgumentException("Not within valid bounds [" + this.getMinValue() + "," + this.getMaxValue() + "]");
        }
        return d;
    }

    @Override
    public String stringify(Double value) {
        return value * 100.0 + "%";
    }
}

