/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.container;

import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.misc.BackpackDataItems;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.mcft.copy.backpacks.network.MessageOpenGui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class ContainerBackpack
extends Container {
    public static final String TAG_SIZE = "size";
    public static final String TAG_TITLE = "title";
    public static final String TAG_LOCALIZED = "localized";
    public final EntityPlayer player;
    public final IBackpack backpack;
    public final BackpackDataItems data;
    public final BackpackSize size;
    public final ItemStackHandler items;
    public final String title;
    public final boolean titleLocalized;

    public ContainerBackpack(EntityPlayer player, IBackpack backpack) {
        this.player = player;
        this.backpack = backpack;
        this.data = (BackpackDataItems)backpack.getData();
        this.size = this.data.getSize();
        this.items = this.data.getItems(player.field_70170_p, player);
        ItemStack stack = backpack.getStack();
        this.title = stack.func_82837_s() ? stack.func_82833_r() : "container.wearablebackpacks.backpack";
        this.titleLocalized = stack.func_82837_s();
        this.setupSlots();
    }

    @SideOnly(value=Side.CLIENT)
    public ContainerBackpack(EntityPlayer player, NBTTagCompound data) {
        this.player = player;
        this.backpack = null;
        this.data = null;
        this.size = BackpackSize.parse(data.func_74781_a(TAG_SIZE));
        this.items = new ItemStackHandler(this.size.getColumns() * this.size.getRows());
        this.title = data.func_74779_i(TAG_TITLE);
        this.titleLocalized = data.func_74767_n(TAG_LOCALIZED);
        this.setupSlots();
    }

    public void open() {
        EntityPlayerMP player = (EntityPlayerMP)this.player;
        player.func_71117_bO();
        player.func_71128_l();
        player.field_71070_bA = this;
        this.field_75152_c = player.field_71139_cq;
        WearableBackpacks.CHANNEL.sendTo(MessageOpenGui.create(this), player);
        this.func_75132_a((IContainerListener)player);
        this.backpack.setPlayersUsing(this.backpack.getPlayersUsing() + 1);
    }

    public int getBorderTop() {
        return 17;
    }

    public int getBorderSide() {
        return 7;
    }

    public int getBorderBottom() {
        return 7;
    }

    public int getBufferInventory() {
        return 13;
    }

    public int getBufferHotbar() {
        return 4;
    }

    public int getMaxColumns() {
        return BackpackSize.MAX.getColumns();
    }

    public int getMaxRows() {
        return BackpackSize.MAX.getRows();
    }

    public int getWidth() {
        return Math.max(this.size.getColumns(), 9) * 18 + this.getBorderSide() * 2;
    }

    public int getHeight() {
        return this.getBorderTop() + this.size.getRows() * 18 + this.getBufferInventory() + 72 + this.getBufferHotbar() + this.getBorderBottom();
    }

    public int getContainerInvWidth() {
        return this.size.getColumns() * 18;
    }

    public int getContainerInvHeight() {
        return this.size.getRows() * 18;
    }

    public int getContainerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getPlayerInvWidth() - this.getContainerInvWidth()) / 2);
    }

    public int getPlayerInvWidth() {
        return 162;
    }

    public int getPlayerInvHeight() {
        return 72 + this.getBufferHotbar();
    }

    public int getPlayerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getContainerInvWidth() - this.getPlayerInvWidth()) / 2);
    }

    protected void setupSlots() {
        this.setupBackpackSlots();
        this.setupPlayerSlots();
    }

    protected void setupBackpackSlots() {
        int xOffset = 1 + this.getContainerInvXOffset();
        int yOffset = 1 + this.getBorderTop();
        int y = 0;
        while (y < this.size.getRows()) {
            for (int x = 0; x < this.size.getColumns(); ++x) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.items, x + y * this.size.getColumns(), xOffset + x * 18, yOffset));
            }
            ++y;
            yOffset += 18;
        }
    }

    protected void setupPlayerSlots() {
        int xOffset = 1 + this.getPlayerInvXOffset();
        int yOffset = 1 + this.getBorderTop() + this.getContainerInvHeight() + this.getBufferInventory();
        int y = 0;
        while (y < 3) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, x + y * 9 + 9, xOffset + x * 18, yOffset));
            }
            ++y;
            yOffset += 18;
        }
        yOffset += this.getBufferHotbar();
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, x, xOffset + x * 18, yOffset));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a(TAG_SIZE, (NBTBase)this.size.serializeNBT());
        compound.func_74778_a(TAG_TITLE, this.title);
        compound.func_74757_a(TAG_LOCALIZED, this.titleLocalized);
    }

    public abstract boolean func_75145_c(EntityPlayer var1);

    public void func_75134_a(EntityPlayer player) {
        if (this.backpack != null) {
            this.backpack.setPlayersUsing(this.backpack.getPlayersUsing() - 1);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null) {
            return null;
        }
        ItemStack stack = slot.func_75211_c();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = stack.func_77946_l();
        if (index < this.items.getSlots() ? !this.func_75135_a(stack, this.items.getSlots(), this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, this.items.getSlots(), false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return result;
    }
}

