/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.item;

import java.util.List;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.mcft.copy.backpacks.client.KeyBindingHandler;
import net.mcft.copy.backpacks.container.ContainerBackpack;
import net.mcft.copy.backpacks.item.IDyeableItem;
import net.mcft.copy.backpacks.misc.BackpackDataItems;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.mcft.copy.backpacks.misc.util.LangUtils;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.mcft.copy.backpacks.misc.util.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class ItemBackpack
extends Item
implements IBackpackType,
IDyeableItem,
ISpecialArmor {
    public static final int DEFAULT_COLOR = 10511680;
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("wearablebackpacks", "backpack/default");
    public static final String[] TAG_CUSTOM_ARMOR = new String[]{"backpack", "armor"};
    public static final String[] TAG_CUSTOM_SIZE = new String[]{"backpack", "size"};

    public ItemBackpack() {
        this.func_77655_b("wearablebackpacks.backpack");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public int getDamageReductionAmount(ItemStack stack) {
        int defaultArmor = WearableBackpacks.CONFIG.backpack.armor.get();
        return NbtUtils.get(stack, Integer.valueOf(defaultArmor), TAG_CUSTOM_ARMOR);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        int leatherOreID = OreDictionary.getOreID((String)"leather");
        return ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)repair), (int)leatherOreID);
    }

    public boolean func_77616_k(ItemStack stack) {
        return BackpackHelper.equipAsChestArmor;
    }

    public int func_77619_b() {
        return 12;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean isEquipped;
        IBackpack backpack = BackpackHelper.getBackpack((Entity)Minecraft.func_71410_x().field_71439_g);
        boolean bl = isEquipped = backpack != null && backpack.getStack() == stack;
        if (LangUtils.tooltipIsShiftKeyDown(tooltip)) {
            boolean equipAsChestArmor = WearableBackpacks.CONFIG.equipAsChestArmor.get();
            boolean enableSelfInteraction = WearableBackpacks.CONFIG.enableSelfInteraction.get();
            if (enableSelfInteraction && (isEquipped || !equipAsChestArmor)) {
                LangUtils.formatTooltipKey(tooltip, "openHint", KeyBindingHandler.openBackpack);
            }
            if (isEquipped) {
                LangUtils.formatTooltip(tooltip, "unequipHint", new Object[0]);
            } else {
                LangUtils.formatTooltip(tooltip, "equipHint" + (!equipAsChestArmor ? ".extended" : ""), new Object[0]);
            }
        }
        if (isEquipped && backpack.getPlayersUsing() > 0) {
            LangUtils.formatTooltipPrepend(tooltip, "\u00a8o", "used", new Object[0]);
        }
        if (!flagIn.func_194127_a()) {
            return;
        }
        NBTBase customSize = NbtUtils.get(stack, TAG_CUSTOM_SIZE);
        if (customSize != null) {
            try {
                tooltip.add("Custom Size: " + BackpackSize.parse(customSize));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            state = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        } else if (facing == EnumFacing.UP) {
            pos = pos.func_177972_a(EnumFacing.UP);
        } else {
            return EnumActionResult.FAIL;
        }
        return state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) && BackpackHelper.placeBackpack(worldIn, pos, player.func_184586_b(hand), (EntityLivingBase)player, false) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (playerIn.field_70170_p.field_72995_K || !playerIn.func_184812_l_() || !BackpackRegistry.canEntityWearBackpacks((Entity)target) || target instanceof EntityPlayer) {
            return false;
        }
        IBackpack backpack = BackpackHelper.getBackpack((Entity)target);
        if (backpack != null) {
            backpack.getType().onFaultyRemoval(target, backpack);
        }
        stack = stack.func_77979_a(1);
        IBackpackData data = BackpackHelper.getBackpackType(stack).createBackpackData(stack);
        BackpackHelper.setEquippedBackpack(target, stack, data);
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnumEnchantmentType.ARMOR && BackpackHelper.equipAsChestArmor;
    }

    @Override
    public void onSpawnedWith(EntityLivingBase entity, IBackpack backpack, String lootTable) {
        if (entity instanceof EntityLiving && entity.func_184582_a(EntityEquipmentSlot.CHEST) == backpack.getStack()) {
            ((EntityLiving)entity).func_184642_a(EntityEquipmentSlot.CHEST, 1.0f);
        }
        IBackpackData data = backpack.getData();
        if (lootTable != null && data instanceof BackpackDataItems) {
            ((BackpackDataItems)data).setLootTable(lootTable, entity.field_70170_p.field_73012_v.nextLong());
        }
    }

    @Override
    public void onEquip(EntityLivingBase entity, TileEntity tileEntity, IBackpack backpack) {
    }

    @Override
    public void onUnequip(EntityLivingBase entity, TileEntity tileEntity, IBackpack backpack) {
    }

    @Override
    public void onPlacedInteract(EntityPlayer player, final TileEntity tileEntity, IBackpack backpack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        new ContainerBackpack(player, backpack){

            @Override
            public boolean func_75145_c(EntityPlayer player) {
                return player.func_70089_S() && !tileEntity.func_145837_r() && player.field_70170_p.func_175625_s(tileEntity.func_174877_v()) == tileEntity && player.func_174818_b(tileEntity.func_174877_v()) <= 64.0;
            }
        }.open();
    }

    @Override
    public void onEquippedInteract(EntityPlayer player, final EntityLivingBase target, IBackpack backpack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        new ContainerBackpack(player, backpack){

            @Override
            public boolean func_75145_c(EntityPlayer player) {
                return BackpackHelper.canInteractWithEquippedBackpack(player, target);
            }
        }.open();
    }

    @Override
    public void onEquippedTick(EntityLivingBase entity, IBackpack backpack) {
    }

    @Override
    public void onDeath(EntityLivingBase entity, IBackpack backpack) {
        if (!(backpack.getData() instanceof BackpackDataItems)) {
            return;
        }
        BackpackDataItems dataItems = (BackpackDataItems)backpack.getData();
        WorldUtils.dropStacksFromEntity((Entity)entity, dataItems.getItems(entity.field_70170_p, null), 4.0f);
    }

    @Override
    public void onEquippedBroken(EntityLivingBase entity, IBackpack backpack) {
        this.onDeath(entity, backpack);
    }

    @Override
    public void onFaultyRemoval(EntityLivingBase entity, IBackpack backpack) {
        this.onDeath(entity, backpack);
    }

    @Override
    public void onBlockBreak(TileEntity tileEntity, IBackpack backpack) {
        if (!(backpack.getData() instanceof BackpackDataItems)) {
            return;
        }
        BackpackDataItems dataItems = (BackpackDataItems)backpack.getData();
        WorldUtils.dropStacksFromBlock(tileEntity, dataItems.getItems(tileEntity.func_145831_w(), null));
    }

    @Override
    public IBackpackData createBackpackData(ItemStack stack) {
        BackpackSize size = WearableBackpacks.CONFIG.backpack.size.get();
        NBTBase customSize = NbtUtils.get(stack, TAG_CUSTOM_SIZE);
        if (customSize != null) {
            try {
                size = BackpackSize.parse(customSize);
            }
            catch (Exception ex) {
                WearableBackpacks.LOG.error("Error trying to deserialize backpack size from custom size NBT tag.", (Throwable)ex);
            }
        }
        return new BackpackDataItems(size);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        int reductionAmount = ((ItemBackpack)armor.func_77973_b()).getDamageReductionAmount(armor);
        int maxDamage = armor.func_77958_k() + 1 - armor.func_77952_i();
        return new ISpecialArmor.ArmorProperties(0, (double)reductionAmount / 25.0, maxDamage);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return ((ItemBackpack)armor.func_77973_b()).getDamageReductionAmount(armor);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(damage, entity);
        if (!stack.func_190926_b()) {
            return;
        }
        IBackpack backpack = BackpackHelper.getBackpack((Entity)entity);
        if (backpack == null) {
            return;
        }
        backpack.getType().onEquippedBroken(entity, backpack);
    }
}

