/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc;

import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.mcft.copy.backpacks.misc.util.MiscUtils;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.mcft.copy.backpacks.network.MessageBackpackUpdate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class BackpackCapability
implements IBackpack {
    public static final String TAG_STACK = "stack";
    public static final String TAG_TYPE = "type";
    public static final String TAG_DATA = "data";
    public static final String TAG_MAY_DESPAWN = "mayDespawn";
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("wearablebackpacks:backpack");
    public final EntityLivingBase entity;
    public ItemStack stack = ItemStack.field_190927_a;
    public IBackpackData data = null;
    public int playersUsing = 0;
    public int lidTicks = 0;
    public int prevLidTicks = 0;
    public IBackpackType lastType = null;
    public BackpackRegistry.BackpackEntry spawnWith = null;
    public boolean mayDespawn = false;

    public BackpackCapability(EntityLivingBase entity) {
        this.entity = entity;
    }

    public boolean isChestArmor() {
        return this.lastType != null || BackpackHelper.getBackpackType(this.entity.func_184582_a(EntityEquipmentSlot.CHEST)) != null;
    }

    @Override
    public ItemStack getStack() {
        if (!this.stack.func_190926_b()) {
            return this.stack;
        }
        ItemStack chestArmor = this.entity.func_184582_a(EntityEquipmentSlot.CHEST);
        return BackpackHelper.getBackpackType(chestArmor) != null ? chestArmor : ItemStack.field_190927_a;
    }

    @Override
    public void setStack(ItemStack value) {
        boolean setChestArmor;
        boolean bl = setChestArmor = !value.func_190926_b() ? BackpackHelper.equipAsChestArmor : this.isChestArmor();
        if (setChestArmor) {
            this.stack = ItemStack.field_190927_a;
            this.lastType = BackpackHelper.getBackpackType(value);
            this.entity.func_184201_a(EntityEquipmentSlot.CHEST, value);
            if (this.entity instanceof EntityPlayer) {
                ((EntityPlayer)this.entity).field_71069_bz.func_75142_b();
            }
        } else {
            this.stack = value;
            this.lastType = null;
            WearableBackpacks.CHANNEL.sendToAllTracking(MessageBackpackUpdate.stack((Entity)this.entity, this.stack), (Entity)this.entity, true);
        }
    }

    @Override
    public IBackpackData getData() {
        return this.data;
    }

    @Override
    public void setData(IBackpackData value) {
        this.data = value;
    }

    @Override
    public int getPlayersUsing() {
        return this.playersUsing;
    }

    @Override
    public void setPlayersUsing(int value) {
        if (value > 0 != this.playersUsing > 0) {
            WearableBackpacks.CHANNEL.sendToAllTracking(MessageBackpackUpdate.open((Entity)this.entity, value > 0), (Entity)this.entity, true);
        }
        this.playersUsing = value;
        this.mayDespawn = false;
    }

    @Override
    public int getLidTicks() {
        return this.lidTicks;
    }

    @Override
    public int getPrevLidTicks() {
        return this.prevLidTicks;
    }

    @Override
    public void setLidTicks(int value) {
        this.prevLidTicks = this.lidTicks;
        this.lidTicks = value;
    }

    @Override
    public IBackpackType getType() {
        return this.lastType != null ? this.lastType : BackpackHelper.getBackpackType(this.getStack());
    }

    public static class Storage
    implements Capability.IStorage<IBackpack> {
        public NBTBase writeNBT(Capability<IBackpack> capability, IBackpack instance, EnumFacing side) {
            BackpackCapability backpack = (BackpackCapability)instance;
            return backpack.stack.func_190926_b() && backpack.data == null ? null : NbtUtils.createCompound(BackpackCapability.TAG_STACK, !backpack.stack.func_190926_b() ? backpack.stack.serializeNBT() : null, BackpackCapability.TAG_DATA, backpack.data != null ? backpack.data.serializeNBT() : null, BackpackCapability.TAG_MAY_DESPAWN, backpack.mayDespawn ? Byte.valueOf((byte)1) : null);
        }

        public void readNBT(Capability<IBackpack> capability, IBackpack instance, EnumFacing side, NBTBase nbt) {
            IBackpackType type;
            BackpackCapability backpack = (BackpackCapability)instance;
            if (!(nbt instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound compound = (NBTTagCompound)nbt;
            ItemStack stack = NbtUtils.readItem(compound.func_74775_l(BackpackCapability.TAG_STACK));
            backpack.setStack(stack);
            if (stack.func_190926_b()) {
                stack = backpack.entity.func_184582_a(EntityEquipmentSlot.CHEST);
                backpack.lastType = type = BackpackHelper.getBackpackType(stack);
                if (type == null) {
                    return;
                }
            } else {
                type = BackpackHelper.getBackpackType(stack);
            }
            IBackpackData data = type.createBackpackData(stack);
            NBTBase dataTag = compound.func_74781_a(BackpackCapability.TAG_DATA);
            if (dataTag != null) {
                data.deserializeNBT(dataTag);
            }
            backpack.setData(data);
            backpack.mayDespawn = compound.func_74767_n(BackpackCapability.TAG_MAY_DESPAWN);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        final BackpackCapability backpack;

        public Provider(EntityLivingBase entity) {
            this.backpack = new BackpackCapability(entity);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == IBackpack.CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == IBackpack.CAPABILITY ? this.backpack : null);
        }

        public void deserializeNBT(NBTTagCompound compound) {
            IBackpackType type;
            this.backpack.stack = NbtUtils.readItem(compound.func_74775_l(BackpackCapability.TAG_STACK));
            if (this.backpack.stack.func_190926_b()) {
                if (!compound.func_150297_b(BackpackCapability.TAG_TYPE, 8)) {
                    return;
                }
                String id = compound.func_74779_i(BackpackCapability.TAG_TYPE);
                this.backpack.lastType = type = BackpackHelper.getBackpackType(MiscUtils.getItemFromName(id));
                if (type == null) {
                    return;
                }
            } else {
                type = BackpackHelper.getBackpackType(this.backpack.stack);
            }
            if (type == null) {
                WearableBackpacks.LOG.error("Backpack type was null when deserializing backpack capability");
                return;
            }
            this.backpack.data = type.createBackpackData(this.backpack.getStack());
            NBTBase dataTag = compound.func_74781_a(BackpackCapability.TAG_DATA);
            if (this.backpack.data != null && dataTag != null) {
                this.backpack.data.deserializeNBT(dataTag);
            }
            this.backpack.mayDespawn = compound.func_74767_n(BackpackCapability.TAG_MAY_DESPAWN);
        }

        public NBTTagCompound serializeNBT() {
            return NbtUtils.createCompound(BackpackCapability.TAG_STACK, !this.backpack.stack.func_190926_b() ? this.backpack.stack.serializeNBT() : null, BackpackCapability.TAG_TYPE, this.backpack.isChestArmor() ? this.backpack.getStack().func_77973_b().getRegistryName().toString() : null, BackpackCapability.TAG_DATA, this.backpack.data != null ? this.backpack.data.serializeNBT() : null, BackpackCapability.TAG_MAY_DESPAWN, this.backpack.mayDespawn ? Byte.valueOf((byte)1) : null);
        }
    }
}

