/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.ModItems;
import vazkii.akashictome.network.message.MessageUnmorphTome;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.util.ItemNBTHelper;

public final class MorphingHandler {
    public static final MorphingHandler INSTANCE = new MorphingHandler();
    public static final String MINECRAFT = "minecraft";
    public static final String TAG_MORPHING = "akashictome:is_morphing";
    public static final String TAG_TOME_DATA = "akashictome:data";
    public static final String TAG_TOME_DISPLAY_NAME = "akashictome:displayName";
    public static final String TAG_ITEM_DEFINED_MOD = "akashictome:definedMod";
    private static final Map<String, String> modNames = new HashMap<String, String>();

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack != null && MorphingHandler.isAkashicTome(stack) && stack.func_77973_b() != ModItems.tome) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUnmorphTome());
        }
    }

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().func_70093_af()) {
            return;
        }
        EntityItem e = event.getEntityItem();
        ItemStack stack = e.func_92059_d();
        if (!stack.func_190926_b() && MorphingHandler.isAkashicTome(stack) && stack.func_77973_b() != ModItems.tome) {
            ItemStack copy;
            NBTTagCompound copyCmp;
            NBTTagCompound morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA).func_74737_b();
            ItemStack morph = MorphingHandler.makeMorphedStack(stack, MINECRAFT, morphData);
            NBTTagCompound newMorphData = morph.func_77978_p().func_74775_l(TAG_TOME_DATA);
            newMorphData.func_82580_o(MorphingHandler.getModFromStack(stack));
            if (!e.func_130014_f_().field_72995_K) {
                EntityItem newItem = new EntityItem(e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v, morph);
                e.func_130014_f_().func_72838_d((Entity)newItem);
            }
            if ((copyCmp = (copy = stack.func_77946_l()).func_77978_p()) == null) {
                copyCmp = new NBTTagCompound();
                copy.func_77982_d(copyCmp);
            }
            copyCmp.func_82580_o("display");
            String displayName = copyCmp.func_74779_i(TAG_TOME_DISPLAY_NAME);
            if (!displayName.isEmpty() && !displayName.equals(copy.func_82833_r())) {
                copy.func_151001_c(displayName);
            }
            copyCmp.func_82580_o(TAG_MORPHING);
            copyCmp.func_82580_o(TAG_TOME_DISPLAY_NAME);
            copyCmp.func_82580_o(TAG_TOME_DATA);
            e.func_92058_a(copy);
        }
    }

    public static String getModFromState(IBlockState state) {
        return MorphingHandler.getModOrAlias(state.func_177230_c().getRegistryName().func_110624_b());
    }

    public static String getModFromStack(ItemStack stack) {
        return MorphingHandler.getModOrAlias(stack.func_190926_b() ? MINECRAFT : stack.func_77973_b().getRegistryName().func_110624_b());
    }

    public static String getModOrAlias(String mod) {
        return ConfigHandler.aliases.containsKey(mod) ? ConfigHandler.aliases.get(mod) : mod;
    }

    public static boolean doesStackHaveModAttached(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA);
        return morphData.func_74764_b(mod);
    }

    public static ItemStack getShiftStackForMod(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return stack;
        }
        String currentMod = MorphingHandler.getModFromStack(stack);
        if (mod.equals(currentMod)) {
            return stack;
        }
        NBTTagCompound morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA);
        return MorphingHandler.makeMorphedStack(stack, mod, morphData);
    }

    public static ItemStack makeMorphedStack(ItemStack currentStack, String targetMod, NBTTagCompound morphData) {
        ItemStack stack;
        String currentMod = ItemNBTHelper.getString((ItemStack)currentStack, (String)TAG_ITEM_DEFINED_MOD, (String)MorphingHandler.getModFromStack(currentStack));
        NBTTagCompound currentCmp = new NBTTagCompound();
        currentStack.func_77955_b(currentCmp);
        currentCmp = currentCmp.func_74737_b();
        if (currentCmp.func_74764_b("tag")) {
            currentCmp.func_74775_l("tag").func_82580_o(TAG_TOME_DATA);
        }
        if (!currentMod.equalsIgnoreCase(MINECRAFT) && !currentMod.equalsIgnoreCase("akashictome")) {
            morphData.func_74782_a(currentMod, (NBTBase)currentCmp);
        }
        if (targetMod.equals(MINECRAFT)) {
            stack = new ItemStack(ModItems.tome);
        } else {
            NBTTagCompound targetCmp = morphData.func_74775_l(targetMod);
            morphData.func_82580_o(targetMod);
            stack = new ItemStack(targetCmp);
            if (stack.func_190926_b()) {
                stack = new ItemStack(ModItems.tome);
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound stackCmp = stack.func_77978_p();
        stackCmp.func_74782_a(TAG_TOME_DATA, (NBTBase)morphData);
        stackCmp.func_74757_a(TAG_MORPHING, true);
        if (stack.func_77973_b() != ModItems.tome) {
            String displayName = stack.func_82833_r();
            if (stackCmp.func_74764_b(TAG_TOME_DISPLAY_NAME)) {
                displayName = stackCmp.func_74779_i(TAG_TOME_DISPLAY_NAME);
            } else {
                stackCmp.func_74778_a(TAG_TOME_DISPLAY_NAME, displayName);
            }
            stack.func_151001_c(TextFormatting.RESET + I18n.func_74837_a((String)"akashictome.sudo_name", (Object[])new Object[]{TextFormatting.GREEN + displayName + TextFormatting.RESET}));
        }
        stack.func_190920_e(1);
        return stack;
    }

    public static String getModNameForId(String modId) {
        return modNames.containsKey(modId = modId.toLowerCase(Locale.ENGLISH)) ? modNames.get(modId) : modId;
    }

    public static boolean isAkashicTome(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == ModItems.tome) {
            return true;
        }
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_MORPHING);
    }

    static {
        for (Map.Entry modEntry : Loader.instance().getIndexedModList().entrySet()) {
            modNames.put(((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH), ((ModContainer)modEntry.getValue()).getName());
        }
    }
}

