/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.subtile.SubTileEntity;

public class RecipePureDaisy {
    public static final int DEFAULT_TIME = 150;
    private static final Map<String, List<ItemStack>> oreMap = new HashMap<String, List<ItemStack>>();
    private final Object input;
    private final IBlockState outputState;
    private final int time;

    public RecipePureDaisy(Object input, IBlockState state) {
        this(input, state, 150);
    }

    public RecipePureDaisy(Object input, IBlockState state, int time) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
        this.input = input;
        this.outputState = state;
        this.time = time;
        if (input != null && !(input instanceof String) && !(input instanceof Block)) {
            throw new IllegalArgumentException("input must be an oredict String or a Block.");
        }
    }

    public boolean matches(World world, BlockPos pos, SubTileEntity pureDaisy, IBlockState state) {
        if (this.input instanceof Block) {
            return state.func_177230_c() == this.input;
        }
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
        String oredict = (String)this.input;
        return this.isOreDict(stack, oredict);
    }

    private boolean isOreDict(ItemStack stack, String entry) {
        Object ores;
        if (stack.func_190926_b()) {
            return false;
        }
        if (oreMap.containsKey(entry)) {
            ores = oreMap.get(entry);
        } else {
            ores = OreDictionary.getOres((String)entry);
            oreMap.put(entry, (List<ItemStack>)ores);
        }
        Iterator iterator = ores.iterator();
        while (iterator.hasNext()) {
            ItemStack ostack = (ItemStack)iterator.next();
            ItemStack cstack = ostack.func_77946_l();
            if (cstack.func_77952_i() == Short.MAX_VALUE) {
                cstack.func_77964_b(stack.func_77952_i());
            }
            if (!stack.func_77969_a(cstack)) continue;
            return true;
        }
        return false;
    }

    public boolean set(World world, BlockPos pos, SubTileEntity pureDaisy) {
        if (!world.field_72995_K) {
            world.func_180501_a(pos, this.outputState, 3);
        }
        return true;
    }

    public Object getInput() {
        return this.input;
    }

    public IBlockState getOutputState() {
        return this.outputState;
    }

    public int getTime() {
        return this.time;
    }
}

