/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import vazkii.botania.client.fx.ParticleRenderDispatcher;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class DebugHandler {
    private static final String PREFIX = TextFormatting.GREEN + "[Botania] " + TextFormatting.RESET;

    private DebugHandler() {
    }

    @SubscribeEvent
    public static void onDrawDebugText(RenderGameOverlayEvent.Text event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            event.getLeft().add("");
            String version = "r1.10-352";
            if (version.contains("GRADLE")) {
                version = "N/A";
            }
            event.getLeft().add(PREFIX + "pS: " + ParticleRenderDispatcher.sparkleFxCount + ", pFS: " + ParticleRenderDispatcher.fakeSparkleFxCount + ", pW: " + ParticleRenderDispatcher.wispFxCount + ", pDIW: " + ParticleRenderDispatcher.depthIgnoringWispFxCount + ", pLB: " + ParticleRenderDispatcher.lightningCount);
            event.getLeft().add(PREFIX + "(CLIENT) netColl: " + ManaNetworkHandler.instance.getAllCollectorsInWorld((World)world).size() + ", netPool: " + ManaNetworkHandler.instance.getAllPoolsInWorld((World)world).size() + ", rv: " + version);
            if (Minecraft.func_71410_x().func_71356_B()) {
                UUID id = Minecraft.func_71410_x().field_71439_g.func_110124_au();
                Entity ent = Minecraft.func_71410_x().func_71401_C().func_175576_a(id);
                if (ent != null) {
                    World serverWorld = Minecraft.func_71410_x().func_71401_C().func_175576_a((UUID)id).field_70170_p;
                    event.getLeft().add(PREFIX + String.format("(INTEGRATED SERVER DIM %d) netColl : %d, netPool: %d", serverWorld.field_73011_w.getDimension(), ManaNetworkHandler.instance.getAllCollectorsInWorld(serverWorld).size(), ManaNetworkHandler.instance.getAllPoolsInWorld(serverWorld).size()));
                }
            }
            if (GuiScreen.func_146271_m() && GuiScreen.func_146272_n()) {
                event.getLeft().add(PREFIX + "Config Context");
                event.getLeft().add("  shaders.enabled: " + ConfigHandler.useShaders);
                event.getLeft().add("  shaders.secondaryUnit: " + ConfigHandler.glSecondaryTextureUnit);
                ContextCapabilities caps = GLContext.getCapabilities();
                event.getLeft().add(PREFIX + "OpenGL Context");
                event.getLeft().add("  GL_VERSION: " + GL11.glGetString((int)7938));
                event.getLeft().add("  GL_RENDERER: " + GL11.glGetString((int)7937));
                event.getLeft().add("  GL_SHADING_LANGUAGE_VERSION: " + GL11.glGetString((int)35724));
                event.getLeft().add("  GL_MAX_TEXTURE_IMAGE_UNITS_ARB: " + GL11.glGetInteger((int)34930));
                event.getLeft().add("  GL_ARB_multitexture: " + caps.GL_ARB_multitexture);
                event.getLeft().add("  GL_ARB_texture_non_power_of_two: " + caps.GL_ARB_texture_non_power_of_two);
                event.getLeft().add("  OpenGL13: " + caps.OpenGL13);
                if (Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.func_178782_a() != null) {
                    BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
                    IBlockState state = world.func_180495_p(pos);
                    state = state.func_185899_b((IBlockAccess)world, pos);
                    if ((state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos)) instanceof IExtendedBlockState) {
                        try {
                            for (Map.Entry e : ((IExtendedBlockState)state).getUnlistedProperties().entrySet()) {
                                event.getRight().add(TextFormatting.LIGHT_PURPLE + ((IUnlistedProperty)e.getKey()).getName() + ": " + TextFormatting.RESET + ((Optional)e.getValue()).orElse(null));
                            }
                        }
                        catch (Throwable t) {
                            event.getRight().add("Error getting extended state");
                        }
                    }
                }
            } else if (Minecraft.field_142025_a) {
                event.getLeft().add(PREFIX + "SHIFT+CMD for context");
            } else {
                event.getLeft().add(PREFIX + "SHIFT+CTRL for context");
            }
        }
    }
}

