/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lexicon.page.PageShedding;

@Mod.EventBusSubscriber
public final class SheddingHandler {
    private static final List<ShedPattern> patterns = new ArrayList<ShedPattern>();
    private static final List<ShedPattern> defaultPatterns = new ArrayList<ShedPattern>();

    private SheddingHandler() {
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        ShedPattern pattern = SheddingHandler.getShedPattern((Entity)event.getEntityLiving());
        if (pattern != null && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(pattern.getRate()) == 0) {
            event.getEntityLiving().func_70099_a(pattern.getItemStack(), 0.0f);
        }
    }

    private static ShedPattern getShedPattern(Entity entity) {
        for (ShedPattern pattern : patterns) {
            if (!pattern.EntityClass.isInstance(entity)) continue;
            return pattern;
        }
        return null;
    }

    public static boolean hasShedding() {
        return patterns.size() > 0;
    }

    public static void addToLexicon() {
        if (!SheddingHandler.hasShedding()) {
            return;
        }
        int i = 1;
        for (ShedPattern pattern : patterns) {
            PageShedding page = new PageShedding(String.valueOf(i), Objects.toString(EntityList.func_191306_a((Class)pattern.EntityClass)), pattern.lexiconSize, pattern.getItemStack());
            LexiconData.shedding.addPage(page);
        }
    }

    public static void loadFromConfig(Configuration config) {
        ArrayList<String> defaultNames = new ArrayList<String>();
        for (ShedPattern pattern : defaultPatterns) {
            SheddingHandler.loadFromConfig(config, pattern.getEntityString(), pattern);
            defaultNames.add(pattern.getEntityString());
        }
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            String name;
            if (!EntityLiving.class.isAssignableFrom(((EntityEntry)entry.getValue()).getEntityClass()) || defaultNames.contains(name = ((ResourceLocation)entry.getKey()).toString())) continue;
            SheddingHandler.loadFromConfig(config, name, null);
        }
    }

    private static void loadFromConfig(Configuration config, String key, ShedPattern defaultPattern) {
        String itemName = "";
        int metadata = 0;
        int rate = -1;
        int lexiconSize = 40;
        if (defaultPattern != null) {
            itemName = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)defaultPattern.getItemStack().func_77973_b())).toString();
            metadata = defaultPattern.getItemStack().func_77952_i();
            rate = defaultPattern.rate;
            lexiconSize = defaultPattern.lexiconSize;
        }
        Property prop = config.get("Shedding", key + ".item", itemName);
        prop.setComment("Configuration of Shedding for " + key);
        itemName = prop.getString();
        rate = config.get("Shedding", key + ".rate", rate).getInt();
        metadata = config.get("Shedding", key + ".metadata", metadata).getInt();
        lexiconSize = config.get("Shedding", key + ".lexiconDisplaySize", lexiconSize).getInt();
        if (itemName != null && Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName)) != null && rate != -1) {
            patterns.add(new ShedPattern(EntityList.getClass((ResourceLocation)new ResourceLocation(key)), new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName)), 1, metadata), rate, lexiconSize));
        }
    }

    private static class ShedPattern {
        private final Class EntityClass;
        private final ItemStack itemStack;
        private final int rate;
        private final int lexiconSize;

        public ShedPattern(Class EntityClass, ItemStack itemStack, int rate, int lexiconSize) {
            this.EntityClass = EntityClass;
            this.itemStack = itemStack;
            this.rate = rate;
            this.lexiconSize = lexiconSize;
        }

        public ItemStack getItemStack() {
            return this.itemStack.func_77946_l();
        }

        public int getRate() {
            return this.rate;
        }

        public String getEntityString() {
            return Objects.toString(EntityList.func_191306_a((Class)this.EntityClass));
        }
    }
}

