/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.material;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.api.recipe.IFlowerComponent;
import vazkii.botania.common.Botania;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.EntityEnderAirBottle;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.lib.LibItemNames;

public class ItemManaResource
extends ItemMod
implements IFlowerComponent,
IElvenItem {
    final int types = 24;

    public ItemManaResource() {
        super("manaResource");
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        boolean ender;
        ItemStack stack = event.getItemStack();
        boolean correctStack = !stack.func_190926_b() && stack.func_77973_b() == Items.field_151069_bo;
        boolean bl = ender = event.getWorld().field_73011_w.getDimension() == 1;
        if (correctStack && ender) {
            if (event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_184609_a(event.getHand());
            } else {
                ItemStack stack1 = new ItemStack((Item)this, 1, 15);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getEntityPlayer(), (ItemStack)stack1);
                stack.func_190918_g(1);
                event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() == 4 || stack.func_77952_i() == 14) {
            return EntityDoppleganger.spawn(player, stack, world, pos, stack.func_77952_i() == 14) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        if (stack.func_77952_i() == 20 && ItemDye.applyBonemeal((ItemStack)stack, (World)world, (BlockPos)pos, (EntityPlayer)player, (EnumHand)hand)) {
            if (!world.field_72995_K) {
                world.func_175718_b(2005, pos, 0);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, side, par8, par9, par10);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() == 15) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                EntityEnderAirBottle b = new EntityEnderAirBottle(world, (EntityLivingBase)player);
                b.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_72838_d((Entity)b);
            } else {
                player.func_184609_a(hand);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 24; ++i) {
                if ("UNUSED".equals(LibItemNames.MANA_RESOURCE_NAMES[i]) || !Botania.gardenOfGlassLoaded && (i == 20 || i == 21)) continue;
                stacks.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack par1ItemStack) {
        return "item." + LibItemNames.MANA_RESOURCE_NAMES[Math.min(23, par1ItemStack.func_77952_i())];
    }

    @Override
    public boolean canFit(ItemStack stack, IPetalApothecary apothecary) {
        int meta = stack.func_77952_i();
        return meta == 6 || meta == 8 || meta == 5 || meta == 23;
    }

    @Override
    public int getParticleColor(ItemStack stack) {
        return 0x9B0000;
    }

    @Override
    public boolean isElvenItem(ItemStack stack) {
        int meta = stack.func_77952_i();
        return meta == 7 || meta == 8 || meta == 9;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return itemStack.func_77952_i() == 11 ? itemStack.func_77946_l() : ItemStack.field_190927_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < LibItemNames.MANA_RESOURCE_NAMES.length; ++i) {
            if ("UNUSED".equals(LibItemNames.MANA_RESOURCE_NAMES[i])) continue;
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation("botania:" + LibItemNames.MANA_RESOURCE_NAMES[i], "inventory"));
        }
    }
}

