/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelicBauble;

@Mod.EventBusSubscriber
public class ItemOdinRing
extends ItemRelicBauble {
    private static final List<String> damageNegations = new ArrayList<String>();
    private final Multimap<String, AttributeModifier> attributes = HashMultimap.create();

    public ItemOdinRing() {
        super("odinRing");
        damageNegations.add(DamageSource.field_76369_e.field_76373_n);
        damageNegations.add(DamageSource.field_76379_h.field_76373_n);
        damageNegations.add(DamageSource.field_76371_c.field_76373_n);
        if (ConfigHandler.ringOfOdinFireResist) {
            damageNegations.add(DamageSource.field_76372_a.field_76373_n);
            damageNegations.add(DamageSource.field_76370_b.field_76373_n);
        }
        damageNegations.add(DamageSource.field_76368_d.field_76373_n);
        damageNegations.add(DamageSource.field_76366_f.field_76373_n);
    }

    @Override
    public void onValidPlayerWornTick(ItemStack stack, EntityPlayer player) {
        if (player.func_70027_ad() && ConfigHandler.ringOfOdinFireResist) {
            player.func_70066_B();
        }
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && ItemOdinRing.getOdinRing(player = (EntityPlayer)event.getEntityLiving()) != null && damageNegations.contains(event.getSource().field_76373_n)) {
            event.setCanceled(true);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }

    public static ItemStack getOdinRing(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        ItemStack stack1 = baubles.getStackInSlot(1);
        ItemStack stack2 = baubles.getStackInSlot(2);
        return ItemOdinRing.isOdinRing(stack1) ? stack1 : (ItemOdinRing.isOdinRing(stack2) ? stack2 : null);
    }

    private static boolean isOdinRing(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == ModItems.odinRing;
    }

    @Override
    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111147_b(this.attributes);
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111148_a(this.attributes);
    }

    private void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ItemOdinRing.getBaubleUUID(stack), "Bauble modifier", 20.0, 0));
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/odin_ring");
    }
}

