/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BlockCamo;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemExchangeRod
extends ItemMod
implements IManaUsingItem,
IWireframeCoordinateListProvider {
    private static final int RANGE = 3;
    private static final int COST = 40;
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_META = "blockMeta";
    private static final String TAG_TARGET_BLOCK_NAME = "targetBlockName";
    private static final String TAG_TARGET_BLOCK_META = "targetBlockMeta";
    private static final String TAG_SWAPPING = "swapping";
    private static final String TAG_SELECT_X = "selectX";
    private static final String TAG_SELECT_Y = "selectY";
    private static final String TAG_SELECT_Z = "selectZ";
    private static final String TAG_EXTRA_RANGE = "extraRange";

    public ItemExchangeRod() {
        super("exchangeRod");
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        int meta;
        Block block;
        List<BlockPos> swap;
        ItemStack stack = player.func_184586_b(hand);
        IBlockState wstate = world.func_180495_p(pos);
        if (player.func_70093_af()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile == null && BlockCamo.isValidBlock(wstate)) {
                Item item = Item.func_150898_a((Block)wstate.func_177230_c());
                this.setBlock(stack, wstate.func_177230_c(), !item.func_77614_k() ? 0 : wstate.func_177230_c().func_176201_c(wstate));
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, stack);
                this.displayRemainderCounter(player, stack);
                return EnumActionResult.SUCCESS;
            }
        } else if (this.canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false) && (swap = this.getBlocksToSwap(world, stack, (block = ItemExchangeRod.getBlock(stack)).func_176203_a(meta = ItemExchangeRod.getBlockMeta(stack)), pos, null)).size() > 0) {
            ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
            ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.func_177958_n());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.func_177956_o());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.func_177952_p());
            this.setTargetBlock(stack, wstate.func_177230_c(), wstate.func_177230_c().func_176201_c(wstate));
            if (world.field_72995_K) {
                player.func_184609_a(hand);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() == this && this.canExchange(stack) && ManaItemHandler.requestManaExactForTool(stack, event.getEntityPlayer(), 40, false) && this.exchange(event.getWorld(), event.getEntityPlayer(), event.getPos(), stack, ItemExchangeRod.getBlock(stack).func_176203_a(ItemExchangeRod.getBlockMeta(stack)))) {
            ManaItemHandler.requestManaExactForTool(stack, event.getEntityPlayer(), 40, true);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int something, boolean somethingelse) {
        int extraRangeNew;
        if (!this.canExchange(stack) || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
        int n = extraRangeNew = IManaProficiencyArmor.Helper.hasProficiency(player, stack) ? 3 : 1;
        if (extraRange != extraRangeNew) {
            ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
        }
        Block block = ItemExchangeRod.getBlock(stack);
        int meta = ItemExchangeRod.getBlockMeta(stack);
        if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
            if (!ManaItemHandler.requestManaExactForTool(stack, player, 40, false)) {
                ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
                return;
            }
            int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
            int y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0);
            int z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0);
            Block targetBlock = ItemExchangeRod.getTargetBlock(stack);
            int targetMeta = ItemExchangeRod.getTargetBlockMeta(stack);
            List<BlockPos> swap = this.getBlocksToSwap(world, stack, block.func_176203_a(meta), new BlockPos(x, y, z), targetBlock.func_176203_a(targetMeta));
            if (swap.size() == 0) {
                ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
                return;
            }
            BlockPos coords = swap.get(world.field_73012_v.nextInt(swap.size()));
            boolean exchange = this.exchange(world, player, coords, stack, block.func_176203_a(meta));
            if (exchange) {
                ManaItemHandler.requestManaExactForTool(stack, player, 40, true);
            } else {
                ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
            }
        }
    }

    public List<BlockPos> getBlocksToSwap(World world, ItemStack stack, IBlockState swapState, BlockPos pos, IBlockState targetState) {
        if (targetState == null) {
            targetState = world.func_180495_p(pos);
        }
        ArrayList<BlockPos> coordsList = new ArrayList<BlockPos>();
        int effRange = 3 + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;
        for (int offsetX = -effRange; offsetX <= effRange; ++offsetX) {
            for (int offsetY = -effRange; offsetY <= effRange; ++offsetY) {
                block2: for (int offsetZ = -effRange; offsetZ <= effRange; ++offsetZ) {
                    BlockPos pos_ = pos.func_177982_a(offsetX, offsetY, offsetZ);
                    IBlockState currentState = world.func_180495_p(pos_);
                    if (currentState != targetState || currentState == swapState) continue;
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        BlockPos adjPos = pos_.func_177972_a(dir);
                        IBlockState adjState = world.func_180495_p(adjPos);
                        if (adjState.isSideSolid((IBlockAccess)world, adjPos, dir.func_176734_d())) continue;
                        coordsList.add(pos_);
                        continue block2;
                    }
                }
            }
        }
        return coordsList;
    }

    public boolean exchange(World world, EntityPlayer player, BlockPos pos, ItemStack stack, IBlockState state) {
        IBlockState stateAt;
        Block blockAt;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            return false;
        }
        ItemStack placeStack = ItemExchangeRod.removeFromInventory(player, stack, state.func_177230_c(), state.func_177230_c().func_176201_c(state), false);
        if (!placeStack.func_190926_b() && !(blockAt = (stateAt = world.func_180495_p(pos)).func_177230_c()).isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) && stateAt.func_185903_a(player, world, pos) > 0.0f && stateAt != state) {
            if (!world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    NonNullList drops = NonNullList.func_191196_a();
                    blockAt.getDrops(drops, (IBlockAccess)world, pos, stateAt, 0);
                    for (ItemStack drop : drops) {
                        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
                    }
                    ItemExchangeRod.removeFromInventory(player, stack, state.func_177230_c(), state.func_177230_c().func_176201_c(state), true);
                }
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                world.func_180501_a(pos, state, 3);
                state.func_177230_c().func_180633_a(world, pos, state, (EntityLivingBase)player, placeStack);
            }
            this.displayRemainderCounter(player, stack);
            return true;
        }
        return false;
    }

    public boolean canExchange(ItemStack stack) {
        Block block = ItemExchangeRod.getBlock(stack);
        return block != null && block != Blocks.field_150350_a;
    }

    public static ItemStack removeFromInventory(EntityPlayer player, IItemHandler inv, ItemStack stack, Block block, int meta, boolean doit) {
        ArrayList<ItemStack> providers = new ArrayList<ItemStack>();
        for (int i = inv.getSlots() - 1; i >= 0; --i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (invStack.func_190926_b()) continue;
            Item item = invStack.func_77973_b();
            if (item == Item.func_150898_a((Block)block) && invStack.func_77952_i() == meta) {
                return inv.extractItem(i, 1, !doit);
            }
            if (!(item instanceof IBlockProvider)) continue;
            providers.add(invStack);
        }
        for (ItemStack provStack : providers) {
            IBlockProvider prov = (IBlockProvider)provStack.func_77973_b();
            if (!prov.provideBlock(player, stack, provStack, block, meta, doit)) continue;
            return new ItemStack(block, 1, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack removeFromInventory(EntityPlayer player, ItemStack stack, Block block, int meta, boolean doit) {
        if (player.field_71075_bZ.field_75098_d) {
            return new ItemStack(block, 1, meta);
        }
        ItemStack outStack = ItemExchangeRod.removeFromInventory(player, (IItemHandler)BotaniaAPI.internalHandler.getBaublesInventoryWrapped(player), stack, block, meta, doit);
        if (outStack.func_190926_b()) {
            outStack = ItemExchangeRod.removeFromInventory(player, (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack, block, meta, doit);
        }
        return outStack;
    }

    public static int getInventoryItemCount(EntityPlayer player, ItemStack stack, Block block, int meta) {
        if (player.field_71075_bZ.field_75098_d) {
            return -1;
        }
        int baubleCount = ItemExchangeRod.getInventoryItemCount(player, (IItemHandler)BotaniaAPI.internalHandler.getBaublesInventoryWrapped(player), stack, block, meta);
        if (baubleCount == -1) {
            return -1;
        }
        int count = ItemExchangeRod.getInventoryItemCount(player, (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack, block, meta);
        if (count == -1) {
            return -1;
        }
        return count + baubleCount;
    }

    public static int getInventoryItemCount(EntityPlayer player, IItemHandler inv, ItemStack stack, Block block, int meta) {
        if (player.field_71075_bZ.field_75098_d) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (invStack.func_190926_b()) continue;
            Item item = invStack.func_77973_b();
            if (item == Item.func_150898_a((Block)block) && invStack.func_77952_i() == meta) {
                count += invStack.func_190916_E();
            }
            if (!(item instanceof IBlockProvider)) continue;
            IBlockProvider prov = (IBlockProvider)item;
            int provCount = prov.getBlockCount(player, stack, invStack, block, meta);
            if (provCount == -1) {
                return -1;
            }
            count += provCount;
        }
        return count;
    }

    public void displayRemainderCounter(EntityPlayer player, ItemStack stack) {
        Block block = ItemExchangeRod.getBlock(stack);
        int meta = ItemExchangeRod.getBlockMeta(stack);
        int count = ItemExchangeRod.getInventoryItemCount(player, stack, block, meta);
        if (!player.field_70170_p.field_72995_K) {
            ItemsRemainingRenderHandler.set(new ItemStack(block, 1, meta), count);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    private boolean setBlock(ItemStack stack, Block block, int meta) {
        ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
        ItemNBTHelper.setInt(stack, TAG_BLOCK_META, meta);
        return true;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack par1ItemStack) {
        Block block = ItemExchangeRod.getBlock(par1ItemStack);
        int meta = ItemExchangeRod.getBlockMeta(par1ItemStack);
        return super.func_77653_i(par1ItemStack) + (block == null ? "" : " (" + TextFormatting.GREEN + new ItemStack(block, 1, meta).func_82833_r() + TextFormatting.RESET + ")");
    }

    public static String getBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    public static Block getBlock(ItemStack stack) {
        Block block = Block.func_149684_b((String)ItemExchangeRod.getBlockName(stack));
        return block;
    }

    public static int getBlockMeta(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_META, 0);
    }

    private void setTargetBlock(ItemStack stack, Block block, int meta) {
        ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
        ItemNBTHelper.setInt(stack, TAG_TARGET_BLOCK_META, meta);
    }

    public static String getTargetBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "");
    }

    public static Block getTargetBlock(ItemStack stack) {
        Block block = Block.func_149684_b((String)ItemExchangeRod.getTargetBlockName(stack));
        return block;
    }

    public static int getTargetBlockMeta(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_TARGET_BLOCK_META, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BlockPos> getWireframesToDraw(EntityPlayer player, ItemStack stack) {
        ItemStack holding = player.func_184614_ca();
        if (holding != stack || !this.canExchange(stack)) {
            return ImmutableList.of();
        }
        Block block = ItemExchangeRod.getBlock(stack);
        int meta = ItemExchangeRod.getBlockMeta(stack);
        RayTraceResult pos = Minecraft.func_71410_x().field_71476_x;
        if (pos != null && pos.func_178782_a() != null) {
            BlockPos bPos = pos.func_178782_a();
            Block targetBlock = null;
            int targetMeta = 0;
            if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
                bPos = new BlockPos(ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0));
                targetBlock = ItemExchangeRod.getTargetBlock(stack);
                targetMeta = ItemExchangeRod.getTargetBlockMeta(stack);
            }
            if (!player.field_70170_p.func_175623_d(bPos)) {
                List<BlockPos> coordsList = this.getBlocksToSwap(player.field_70170_p, stack, block.func_176203_a(meta), bPos, targetBlock == null ? null : targetBlock.func_176203_a(targetMeta));
                for (BlockPos coords : coordsList) {
                    if (!coords.equals((Object)bPos)) continue;
                    coordsList.remove(coords);
                    break;
                }
                return coordsList;
            }
        }
        return ImmutableList.of();
    }

    @Override
    public BlockPos getSourceWireframe(EntityPlayer player, ItemStack stack) {
        return null;
    }
}

