/*
 * Decompiled with CFR 0.152.
 */
package openmods.entity;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.utils.BlockManipulator;
import openmods.utils.NbtUtils;

public class EntityBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final String TAG_TILE_ENTITY = "TileEntity";
    private static final String TAG_BLOCK_META = "BlockMeta";
    private static final String TAG_BLOCK_ID = "BlockId";
    public static final EnumFacing[] PLACE_DIRECTIONS = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN};
    private static final String TAG_BLOCK_STATE_ID = "BlockState";
    private boolean hasGravity = false;
    private boolean shouldDrop = true;
    private boolean hasAirResistance = true;
    private IBlockState blockState;
    private NBTTagCompound tileEntity;

    public EntityBlock(World world) {
        super(world);
        this.func_70105_a(0.925f, 0.925f);
    }

    public EntityBlock(World world, IBlockState state, NBTTagCompound tileEntity) {
        super(world);
        this.func_70105_a(0.925f, 0.925f);
    }

    public static void registerFixes(DataFixer fixer, final Class<? extends EntityBlock> cls) {
        fixer.func_188258_a(FixTypes.ENTITY, new IDataWalker(){

            public NBTTagCompound func_188266_a(IDataFixer fixer, NBTTagCompound compound, int versionIn) {
                if (EntityList.func_191306_a((Class)cls).equals((Object)new ResourceLocation(compound.func_74779_i("id"))) && compound.func_150297_b(EntityBlock.TAG_TILE_ENTITY, 10)) {
                    NBTTagCompound teTag = compound.func_74775_l(EntityBlock.TAG_TILE_ENTITY);
                    NBTTagCompound fixedTeTag = fixer.func_188251_a((IFixType)FixTypes.BLOCK_ENTITY, teTag, versionIn);
                    compound.func_74782_a(EntityBlock.TAG_TILE_ENTITY, (NBTBase)fixedTeTag);
                }
                return compound;
            }
        });
    }

    public static EntityBlock create(EntityPlayer player, World world, BlockPos pos) {
        return EntityBlock.create((EntityLivingBase)player, world, pos, new EntityFactory(){

            @Override
            public EntityBlock create(World world) {
                return new EntityBlock(world);
            }
        });
    }

    public static EntityBlock create(EntityLivingBase creator, World world, BlockPos pos, EntityFactory factory) {
        boolean blockRemoved;
        if (world.func_175623_d(pos)) {
            return null;
        }
        if (!(creator instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)creator;
        EntityBlock entity = factory.create(world);
        entity.blockState = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            entity.tileEntity = te.func_189515_b(new NBTTagCompound());
        }
        if (!(blockRemoved = new BlockManipulator(world, player, pos).setSilentTeRemove(true).remove())) {
            return null;
        }
        entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
        return entity;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public void setShouldDrop(boolean bool) {
        this.shouldDrop = bool;
    }

    public void setHasAirResistance(boolean bool) {
        this.hasAirResistance = bool;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_BLOCK_STATE_ID)) {
            int blockStateId = tag.func_74762_e(TAG_BLOCK_STATE_ID);
            this.blockState = Block.func_176220_d((int)blockStateId);
        } else {
            int meta = tag.func_74771_c(TAG_BLOCK_META) & 0xFF;
            ResourceLocation blockId = NbtUtils.readResourceLocation(tag.func_74775_l(TAG_BLOCK_ID));
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)blockId);
            this.blockState = block.func_176203_a(meta);
        }
        this.tileEntity = tag.func_150297_b(TAG_TILE_ENTITY, 10) ? tag.func_74775_l(TAG_TILE_ENTITY) : null;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a(TAG_BLOCK_STATE_ID, Block.func_176210_f((IBlockState)this.blockState));
        if (this.tileEntity != null) {
            tag.func_74782_a(TAG_TILE_ENTITY, (NBTBase)this.tileEntity.func_74737_b());
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(Block.func_176210_f((IBlockState)this.blockState));
        data.writeBoolean(this.hasGravity);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.blockState = Block.func_176220_d((int)additionalData.readInt());
        this.hasGravity = additionalData.readBoolean();
    }

    public void func_70071_h_() {
        if (this.field_70163_u < -500.0) {
            this.func_70106_y();
            return;
        }
        if (this.hasGravity) {
            this.field_70181_x -= (double)0.04f;
        }
        if (this.hasAirResistance) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70066_B();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        Block block = this.blockState.func_177230_c();
        if (block == null) {
            this.func_70106_y();
        }
        if (this.field_70170_p instanceof WorldServer && this.shouldPlaceBlock()) {
            BlockPos dropPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (!this.tryPlaceBlock((WorldServer)this.field_70170_p, dropPos)) {
                this.dropBlock();
            }
            this.func_70106_y();
        }
    }

    protected boolean shouldPlaceBlock() {
        return this.field_70122_E && this.shouldDrop;
    }

    private boolean tryPlaceBlock(final WorldServer world, final BlockPos pos) {
        return FakePlayerPool.instance.executeOnPlayer(world, new FakePlayerPool.PlayerUserReturning<Boolean>(){

            @Override
            public Boolean usePlayer(OpenModsFakePlayer fakePlayer) {
                if (EntityBlock.this.tryPlaceBlock((EntityPlayer)fakePlayer, world, pos, EnumFacing.DOWN)) {
                    return true;
                }
                for (EnumFacing dir : PLACE_DIRECTIONS) {
                    if (!EntityBlock.this.tryPlaceBlock((EntityPlayer)fakePlayer, world, pos, dir)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private boolean tryPlaceBlock(EntityPlayer player, WorldServer world, BlockPos pos, EnumFacing fromSide) {
        if (!world.func_175623_d(pos)) {
            return false;
        }
        boolean blockPlaced = new BlockManipulator((World)world, player, pos).place(this.blockState, fromSide, EnumHand.MAIN_HAND);
        if (!blockPlaced) {
            return false;
        }
        if (this.tileEntity != null) {
            this.tileEntity.func_74768_a("x", pos.func_177958_n());
            this.tileEntity.func_74768_a("y", pos.func_177956_o());
            this.tileEntity.func_74768_a("z", pos.func_177952_p());
            TileEntity te = world.func_175625_s(pos);
            te.func_145839_a(this.tileEntity);
        }
        return true;
    }

    private void dropBlock() {
        Block block = this.blockState.func_177230_c();
        Random rand = this.field_70170_p.field_73012_v;
        int count = block.quantityDropped(this.blockState, 0, rand);
        for (int i = 0; i < count; ++i) {
            Item item = block.func_180660_a(this.blockState, rand, 0);
            if (item == null) continue;
            ItemStack toDrop = new ItemStack(item, 1, block.func_180651_a(this.blockState));
            this.func_70099_a(toDrop, 0.1f);
        }
        if (this.tileEntity instanceof IInventory) {
            IInventory inv = (IInventory)this.tileEntity;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is == null) continue;
                this.func_70099_a(is, 0.1f);
            }
        }
    }

    public void setHasGravity(boolean gravity) {
        this.hasGravity = gravity;
    }

    public boolean hasGravity() {
        return this.hasGravity;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    protected void func_70081_e(int i) {
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.dropBlock();
        }
        this.func_70106_y();
        return false;
    }

    protected void func_70088_a() {
    }

    public static interface EntityFactory {
        public EntityBlock create(World var1);
    }
}

