/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import openmods.geometry.Matrix2d;

public class BlockTextureTransform {
    private static final Matrix2d MIRROR_U = Matrix2d.createMirrorX();
    private static final Matrix2d MIRROR_V = Matrix2d.createMirrorY();
    private static final Matrix2d MIRROR_UV = Matrix2d.createMirrorXY();
    private static final Matrix2d ROTATE_CW = Matrix2d.createRotateCW();
    private static final Matrix2d ROTATE_CCW = Matrix2d.createRotateCCW();
    private static final Matrix2d SWAP = Matrix2d.createSwap();
    private final Map<EnumFacing, Matrix2d> transforms;
    private final Map<EnumFacing, Matrix2d> inverseTransforms;

    private BlockTextureTransform(Map<EnumFacing, Matrix2d> transforms, Map<EnumFacing, Matrix2d> inverseTransforms) {
        this.transforms = transforms;
        this.inverseTransforms = inverseTransforms;
    }

    public TexCoords worldVecToTextureCoords(EnumFacing side, double x, double y, double z) {
        double h;
        double wallY;
        double wallX;
        switch (side) {
            case UP: {
                wallX = x;
                wallY = z;
                h = y - 1.0;
                break;
            }
            case DOWN: {
                wallX = x;
                wallY = z;
                h = -y;
                break;
            }
            case EAST: {
                wallX = z;
                wallY = 1.0 - y;
                h = x - 1.0;
                break;
            }
            case WEST: {
                wallX = z;
                wallY = 1.0 - y;
                h = -x;
                break;
            }
            case NORTH: {
                wallX = x;
                wallY = 1.0 - y;
                h = -z;
                break;
            }
            case SOUTH: {
                wallX = x;
                wallY = 1.0 - y;
                h = z - 1.0;
                break;
            }
            default: {
                throw new IllegalArgumentException(side.toString());
            }
        }
        Matrix2d transformation = this.transforms.get(side);
        double u = transformation.transformX(wallX - 0.5, wallY - 0.5) + 0.5;
        double v = transformation.transformY(wallX - 0.5, wallY - 0.5) + 0.5;
        return new TexCoords(u, v, h);
    }

    public WorldCoords textureCoordsToWorldVec(EnumFacing side, double u, double v, double h) {
        double globalZ;
        double globalY;
        double globalX;
        Matrix2d transformation = this.inverseTransforms.get(side);
        if (transformation == null) {
            throw new IllegalArgumentException(side.toString());
        }
        double wallX = transformation.transformX(u - 0.5, v - 0.5) + 0.5;
        double wallY = transformation.transformY(u - 0.5, v - 0.5) + 0.5;
        switch (side) {
            case UP: {
                globalX = wallX;
                globalY = h + 1.0;
                globalZ = wallY;
                break;
            }
            case DOWN: {
                globalX = wallX;
                globalY = -h;
                globalZ = wallY;
                break;
            }
            case EAST: {
                globalX = h + 1.0;
                globalY = 1.0 - wallY;
                globalZ = wallX;
                break;
            }
            case WEST: {
                globalX = -h;
                globalY = 1.0 - wallY;
                globalZ = wallX;
                break;
            }
            case NORTH: {
                globalX = wallX;
                globalY = 1.0 - wallY;
                globalZ = -h;
                break;
            }
            case SOUTH: {
                globalX = wallX;
                globalY = 1.0 - wallY;
                globalZ = h + 1.0;
                break;
            }
            default: {
                throw new IllegalArgumentException(side.toString());
            }
        }
        return new WorldCoords(globalX, globalY, globalZ);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder builderFromThis() {
        return new Builder(this.transforms);
    }

    public static class Builder {
        private final Map<EnumFacing, Matrix2d> transforms = Maps.newEnumMap(EnumFacing.class);

        private Builder() {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.transforms.put(dir, Matrix2d.createIdentity());
            }
        }

        private Builder(Map<EnumFacing, Matrix2d> transforms) {
            for (Map.Entry<EnumFacing, Matrix2d> e : transforms.entrySet()) {
                this.transforms.put(e.getKey(), e.getValue().copy());
            }
        }

        public BlockTextureTransform build() {
            EnumMap inverseTransforms = Maps.newEnumMap(this.transforms);
            for (Map.Entry entry : inverseTransforms.entrySet()) {
                entry.setValue(((Matrix2d)entry.getValue()).invertCopy());
            }
            return new BlockTextureTransform(Maps.newEnumMap(this.transforms), inverseTransforms);
        }

        public Builder mirrorU(EnumFacing side) {
            this.transforms.get(side).mulRight(MIRROR_U);
            return this;
        }

        public Builder mirrorV(EnumFacing side) {
            this.transforms.get(side).mulRight(MIRROR_V);
            return this;
        }

        public Builder mirrorUV(EnumFacing side) {
            this.transforms.get(side).mulRight(MIRROR_UV);
            return this;
        }

        public Builder rotateCW(EnumFacing side) {
            this.transforms.get(side).mulRight(ROTATE_CW);
            return this;
        }

        public Builder rotateCCW(EnumFacing side) {
            this.transforms.get(side).mulRight(ROTATE_CCW);
            return this;
        }

        public Builder swapUV(EnumFacing side) {
            this.transforms.get(side).mulRight(SWAP);
            return this;
        }
    }

    public static class WorldCoords {
        public final double x;
        public final double y;
        public final double z;

        public WorldCoords(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class TexCoords {
        public final double u;
        public final double v;
        public final double h;

        public TexCoords(double u, double v, double h) {
            this.u = u;
            this.v = v;
            this.h = h;
        }
    }
}

