/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BucketFillHandler {
    @Nonnull
    private final ItemStack filledBucket;
    private final FluidStack containedFluid;

    public BucketFillHandler(@Nonnull ItemStack filledBucket, FluidStack containedFluid) {
        this.filledBucket = filledBucket;
        this.containedFluid = containedFluid;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent evt) {
        IFluidHandler source;
        FluidStack drained;
        if (evt.getResult() != Event.Result.DEFAULT) {
            return;
        }
        RayTraceResult target = evt.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity te = evt.getWorld().func_175625_s(target.func_178782_a());
        if (te == null) {
            return;
        }
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b) && this.containedFluid.isFluidStackIdentical(drained = (source = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b)).drain(1000, false))) {
            source.drain(1000, true);
            evt.setFilledBucket(this.filledBucket.func_77946_l());
            evt.setResult(Event.Result.ALLOW);
        }
    }
}

