/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import net.minecraftforge.registries.IForgeRegistry;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.MethodEntry;
import openmods.network.rpc.RpcCall;
import openmods.network.senders.IPacketSender;
import openmods.utils.CommonRegistryCallbacks;
import org.apache.commons.lang3.ArrayUtils;

public class RpcProxyFactory {
    private final IForgeRegistry<MethodEntry> registry;

    RpcProxyFactory(IForgeRegistry<MethodEntry> registry) {
        this.registry = registry;
    }

    public <T> T createProxy(ClassLoader loader, final IPacketSender sender, final IRpcTarget wrapper, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        Class[] allInterfaces = (Class[])ArrayUtils.add((Object[])extraIntf, mainIntf);
        final Map methodMap = CommonRegistryCallbacks.getObjectToEntryMap(this.registry);
        Object proxy = Proxy.newProxyInstance(loader, allInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MethodEntry entry = (MethodEntry)methodMap.get(method);
                if (entry != null) {
                    RpcCall call = new RpcCall(wrapper, entry, args);
                    sender.sendMessage(call);
                }
                return null;
            }
        });
        return (T)proxy;
    }
}

