/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.senders;

import io.netty.channel.Channel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import openmods.network.senders.IPacketSender;
import openmods.network.senders.ITargetedPacketSender;
import openmods.network.senders.PacketSenderBase;
import openmods.network.senders.TargetedPacketSenderBase;

public class FmlPacketSenderFactory {
    public static ITargetedPacketSender<EntityPlayer> createPlayerSender(Channel channel) {
        return new FmlTargetedPacketSender<EntityPlayer>(channel, FMLOutboundHandler.OutboundTarget.PLAYER);
    }

    public static ITargetedPacketSender<Integer> createDimensionSender(Channel channel) {
        return new FmlTargetedPacketSender<Integer>(channel, FMLOutboundHandler.OutboundTarget.DIMENSION);
    }

    public static ITargetedPacketSender<NetworkRegistry.TargetPoint> createPointSender(Channel channel) {
        return new FmlTargetedPacketSender<NetworkRegistry.TargetPoint>(channel, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
    }

    public static IPacketSender createSender(Channel channel, FMLOutboundHandler.OutboundTarget target) {
        return new FmlPacketSender(channel, target);
    }

    private static class FmlTargetedPacketSender<T>
    extends TargetedPacketSenderBase<T> {
        private final FMLOutboundHandler.OutboundTarget selector;

        public FmlTargetedPacketSender(Channel channel, FMLOutboundHandler.OutboundTarget selector) {
            super(channel);
            this.selector = selector;
        }

        @Override
        protected void configureChannel(Channel channel, T target) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)this.selector);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(target);
        }
    }

    private static class FmlPacketSender
    extends PacketSenderBase {
        private final FMLOutboundHandler.OutboundTarget selector;

        public FmlPacketSender(Channel channel, FMLOutboundHandler.OutboundTarget selector) {
            super(channel);
            this.selector = selector;
        }

        @Override
        protected void configureChannel(Channel channel) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)this.selector);
        }
    }
}

