/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openmods.structured.IStructureObserver;
import openmods.structured.StructureObserver;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class StructuredData<C extends IStructureContainer<E>, E extends IStructureElement> {
    protected static final int NULL = -1;
    protected final SortedMap<Integer, E> elements = Maps.newTreeMap();
    protected final SortedMap<Integer, C> containers = Maps.newTreeMap();
    protected final TreeMultimap<Integer, Integer> containerToElement = TreeMultimap.create();
    protected final TIntIntHashMap elementToContainer = new TIntIntHashMap(10, 0.5f, -1, -1);
    protected final IStructureObserver<C, E> observer;

    public boolean isEmpty() {
        return this.elements.isEmpty() && this.containers.isEmpty();
    }

    public StructuredData(IStructureObserver<C, E> observer) {
        this.observer = observer;
    }

    public StructuredData() {
        this(new StructureObserver());
    }

    public void removeAll() {
        for (Map.Entry<Integer, C> c : this.containers.entrySet()) {
            int containerId = c.getKey();
            IStructureContainer container = (IStructureContainer)c.getValue();
            this.observer.onContainerRemoved(containerId, container);
            for (Integer elementId : this.containerToElement.get((Object)containerId)) {
                IStructureElement element = (IStructureElement)this.elements.get(elementId);
                Preconditions.checkNotNull((Object)element);
                this.observer.onElementRemoved(containerId, container, elementId, element);
            }
        }
        this.elements.clear();
        this.containers.clear();
        this.containerToElement.clear();
        this.elementToContainer.clear();
    }

    protected SortedSet<Integer> removeContainer(int containerId) {
        Preconditions.checkArgument((boolean)this.containerToElement.containsKey((Object)containerId), (String)"Container %s doesn't exists", (int)containerId);
        SortedSet removedElements = this.containerToElement.removeAll((Object)containerId);
        IStructureContainer container = (IStructureContainer)this.containers.remove(containerId);
        this.observer.onContainerRemoved(containerId, container);
        for (Integer elementId : removedElements) {
            IStructureElement element = (IStructureElement)this.elements.remove(elementId);
            this.elementToContainer.remove(elementId.intValue());
            this.observer.onElementRemoved(containerId, container, elementId, element);
        }
        return removedElements;
    }

    protected int addContainer(final int containerId, C container, int firstElementId) {
        final MutableInt nextElementId = new MutableInt(firstElementId);
        container.createElements(new IStructureContainer.IElementAddCallback<E>((IStructureContainer)container){
            final /* synthetic */ IStructureContainer val$container;
            {
                this.val$container = iStructureContainer;
            }

            @Override
            public int addElement(E element) {
                int elementId = nextElementId.intValue();
                nextElementId.increment();
                StructuredData.this.elements.put(elementId, element);
                StructuredData.this.containerToElement.put((Object)containerId, (Object)elementId);
                StructuredData.this.elementToContainer.put(elementId, containerId);
                StructuredData.this.observer.onElementAdded(containerId, this.val$container, elementId, element);
                return elementId;
            }
        });
        this.containers.put(containerId, container);
        this.observer.onContainerAdded(containerId, container);
        return nextElementId.intValue();
    }
}

