/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import openmods.api.IValueProvider;
import openmods.liquids.GenericTank;
import openmods.sync.ISyncableObject;

public class SyncableTank
extends GenericTank
implements ISyncableObject,
IValueProvider<FluidStack> {
    private boolean dirty = false;

    public SyncableTank() {
        super(0);
    }

    public SyncableTank(int capacity) {
        super(capacity);
    }

    public SyncableTank(int capacity, Fluid ... acceptableFluids) {
        super(capacity, acceptableFluids);
    }

    public SyncableTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity, acceptableFluids);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void readFromStream(PacketBuffer stream) throws IOException {
        if (stream.readBoolean()) {
            String fluidName = stream.func_150789_c(Short.MAX_VALUE);
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            int fluidAmount = stream.readInt();
            this.fluid = new FluidStack(fluid, fluidAmount);
            this.fluid.tag = stream.func_150793_b();
        } else {
            this.fluid = null;
        }
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        if (this.fluid != null) {
            stream.writeBoolean(true);
            String id = FluidRegistry.getFluidName((Fluid)this.fluid.getFluid());
            stream.func_180714_a(id);
            stream.writeInt(this.fluid.amount);
            stream.func_150786_a(this.fluid.tag);
        } else {
            stream.writeBoolean(false);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        NBTTagCompound tankTag = new NBTTagCompound();
        this.writeToNBT(tankTag);
        tag.func_74782_a(name, (NBTBase)tankTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_150297_b(name, 10)) {
            NBTTagCompound tankTag = tag.func_74775_l(name);
            this.readFromNBT(tankTag);
        } else {
            this.readFromNBT(tag);
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        int filled = super.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.markDirty();
        }
        return filled;
    }

    public FluidStack drain(FluidStack stack, boolean doDrain) {
        FluidStack drained = super.drain(stack, doDrain);
        if (doDrain && drained != null) {
            this.markDirty();
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        if (doDrain && drained != null) {
            this.markDirty();
        }
        return drained;
    }

    @Override
    public FluidStack getValue() {
        FluidStack stack = super.getFluid();
        return stack != null ? stack.copy() : null;
    }

    public void setFluid(@Nullable FluidStack fluid) {
        super.setFluid(fluid);
        this.markDirty();
    }
}

