/*
 * Decompiled with CFR 0.152.
 */
package openmods.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openmods.api.IInventoryCallback;
import openmods.block.BlockRotationMode;
import openmods.block.IBlockRotationMode;
import openmods.block.OpenBlock;
import openmods.geometry.LocalDirections;
import openmods.geometry.Orientation;
import openmods.inventory.GenericInventory;
import openmods.network.DimCoord;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.IRpcTargetProvider;
import openmods.network.rpc.RpcCallDispatcher;
import openmods.network.rpc.targets.TileEntityRpcTarget;
import openmods.network.senders.IPacketSender;
import openmods.reflection.TypeUtils;
import openmods.utils.BlockUtils;
import openmods.utils.OptionalInt;

public abstract class OpenTileEntity
extends TileEntity
implements IRpcTargetProvider {
    public void setup() {
    }

    public DimCoord getDimCoords() {
        return new DimCoord(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
    }

    public Orientation getOrientation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return this.getOrientation(state);
    }

    public Orientation getOrientation(IBlockState state) {
        Block block = state.func_177230_c();
        if (!(block instanceof OpenBlock)) {
            return Orientation.XP_YP;
        }
        OpenBlock openBlock = (OpenBlock)block;
        return openBlock.getOrientation(state);
    }

    public IBlockRotationMode getRotationMode() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return this.getRotationMode(state);
    }

    public IBlockRotationMode getRotationMode(IBlockState state) {
        Block block = state.func_177230_c();
        if (!(block instanceof OpenBlock)) {
            return BlockRotationMode.NONE;
        }
        OpenBlock openBlock = (OpenBlock)block;
        return openBlock.rotationMode;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return this.getFront(state);
    }

    public EnumFacing getFront(IBlockState state) {
        Block block = state.func_177230_c();
        if (!(block instanceof OpenBlock)) {
            return EnumFacing.NORTH;
        }
        OpenBlock openBlock = (OpenBlock)block;
        return openBlock.getFront(state);
    }

    public EnumFacing getBack() {
        return this.getFront().func_176734_d();
    }

    public LocalDirections getLocalDirections() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (!(block instanceof OpenBlock)) {
            return LocalDirections.fromFrontAndTop(EnumFacing.NORTH, EnumFacing.UP);
        }
        OpenBlock openBlock = (OpenBlock)block;
        return openBlock.getLocalDirections(state);
    }

    public boolean isAddedToWorld() {
        return this.field_145850_b != null;
    }

    protected TileEntity getTileEntity(BlockPos blockPos) {
        return this.field_145850_b != null && this.field_145850_b.func_175667_e(blockPos) ? this.field_145850_b.func_175625_s(blockPos) : null;
    }

    public TileEntity getTileInDirection(EnumFacing direction) {
        return this.getTileEntity(this.field_174879_c.func_177972_a(direction));
    }

    public boolean isAirBlock(EnumFacing direction) {
        return this.field_145850_b != null && this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(direction));
    }

    protected void playSoundAtBlock(SoundEvent sound, SoundCategory category, float volume, float pitch) {
        BlockUtils.playSoundAtPos(this.field_145850_b, this.field_174879_c, sound, category, volume, pitch);
    }

    protected void playSoundAtBlock(SoundEvent sound, float volume, float pitch) {
        this.playSoundAtBlock(sound, SoundCategory.BLOCKS, volume, pitch);
    }

    protected void spawnParticle(EnumParticleTypes particle, double dx, double dy, double dz, double vx, double vy, double vz, int ... args) {
        this.field_145850_b.func_175688_a(particle, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, vx, vy, vz, args);
    }

    protected void spawnParticle(EnumParticleTypes particle, double vx, double vy, double vz, int ... args) {
        this.spawnParticle(particle, 0.5, 0.5, 0.5, vx, vy, vz, args);
    }

    public void sendBlockEvent(int event, int param) {
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), event, param);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void openGui(Object instance, EntityPlayer player) {
        player.openGui(instance, -1, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public AxisAlignedBB getBB() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    @Override
    public IRpcTarget createRpcTarget() {
        return new TileEntityRpcTarget(this);
    }

    public <T> T createProxy(IPacketSender sender, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        TypeUtils.isInstance(this, mainIntf, extraIntf);
        return RpcCallDispatcher.instance().createProxy(this.createRpcTarget(), sender, mainIntf, extraIntf);
    }

    public <T> T createClientRpcProxy(Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        IPacketSender sender = RpcCallDispatcher.instance().senders.client;
        return this.createProxy(sender, mainIntf, extraIntf);
    }

    public <T> T createServerRpcProxy(Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        IPacketSender sender = RpcCallDispatcher.instance().senders.block.bind(this.getDimCoords());
        return this.createProxy(sender, mainIntf, extraIntf);
    }

    public void markUpdated() {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    protected IInventoryCallback createInventoryCallback() {
        return new IInventoryCallback(){

            @Override
            public void onInventoryChanged(IInventory inventory, OptionalInt slotNumber) {
                OpenTileEntity.this.markUpdated();
            }
        };
    }

    protected GenericInventory registerInventoryCallback(GenericInventory inventory) {
        return inventory.addCallback(this.createInventoryCallback());
    }

    public boolean isValid(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_174831_c(this.field_174879_c) <= 64.0;
    }
}

