/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.gottagofast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.JarFile;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GottaGoFastMod
extends DummyModContainer {
    public static final String MOD_ID = "gottagofast";
    public static final String MOD_NAME = "Gotta Go Fast";
    public static final String VERSION = "1.0";
    public static Logger logger = LogManager.getLogger((String)"Gotta Go Fast");
    public static File myModFile;

    public GottaGoFastMod() {
        super(GottaGoFastMod.loadMcmodInfo());
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void handleModStateEvent(FMLEvent event) {
        if (event instanceof FMLConstructionEvent) {
            ImmutableList certs = CertificateHelper.getFingerprints((Certificate[])((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getCertificates());
            boolean foundCert = false;
            String myFinger = "5E:7C:24:5D:57:05:8D:37:2B:B1:17:8B:F0:9A:25:9F:D7:08:A9:20".toLowerCase().replaceAll(":", "");
            for (String c2 : certs) {
                if (!myFinger.equals(c2)) continue;
                foundCert = true;
                break;
            }
            if (!foundCert) {
                logger.error("Warning: did not find the signature I was expecting!");
                logger.info("Available fingerprints: ");
                certs.forEach(c -> logger.info(c));
            }
        }
        if (event instanceof FMLPreInitializationEvent) {
            // empty if block
        }
    }

    private static ModMetadata loadMcmodInfo() {
        InputStream is = null;
        if (myModFile != null) {
            try {
                if (myModFile.isDirectory()) {
                    is = new FileInputStream(new File(myModFile, "mcmod.info"));
                } else {
                    JarFile myjar = new JarFile(myModFile);
                    is = myjar.getInputStream(myjar.getJarEntry("mcmod.info"));
                }
            }
            catch (Exception e) {
                logger.error("Could not load mcmod.info", (Throwable)e);
            }
        }
        ImmutableMap dummyMeta = ImmutableMap.builder().put((Object)"name", (Object)MOD_NAME).put((Object)"version", (Object)VERSION).build();
        return MetadataCollection.from(is, (String)MOD_ID).getMetadataForId(MOD_ID, (Map)dummyMeta);
    }

    public File getSource() {
        return myModFile;
    }

    public Class<?> getCustomResourcePackClass() {
        if (myModFile == null) {
            return null;
        }
        try {
            return this.getSource().isDirectory() ? Class.forName("net.minecraftforge.fml.client.FMLFolderResourcePack", true, ((Object)((Object)this)).getClass().getClassLoader()) : Class.forName("net.minecraftforge.fml.client.FMLFileResourcePack", true, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

