/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.betterwithmods;

import betterwithmods.common.registry.anvil.AnvilCraftingManager;
import betterwithmods.common.registry.anvil.ShapedAnvilRecipe;
import betterwithmods.common.registry.anvil.ShapelessAnvilRecipe;
import betterwithmods.module.gameplay.AnvilRecipes;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.betterwithmods.Anvil")
@ModOnly(value="betterwithmods")
@ZenRegister
public class Anvil {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] inputs) {
        CraftTweakerAPI.apply((IAction)new AddShaped(output, inputs));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] inputs) {
        CraftTweakerAPI.apply((IAction)new AddShapeless(output, inputs));
    }

    @ZenMethod
    public static void removeShaped(IItemStack output, @Optional IIngredient[][] ingredients) {
        CraftTweakerAPI.apply((IAction)new RemoveShaped(output, ingredients));
    }

    @ZenMethod
    public static void removeShapeless(IItemStack output, @Optional IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new RemoveShapeless(output, ingredients));
    }

    public static Object[] toShapedAnvilObjects(IIngredient[][] ingredients) {
        if (ingredients == null) {
            return null;
        }
        ArrayList<Object> prep = new ArrayList<Object>();
        char chr = 'a';
        for (int y = 0; y < 4; ++y) {
            StringBuilder matrix = new StringBuilder();
            for (int x = 0; x < 4; ++x) {
                if (x >= ingredients.length || ingredients[x] == null || y >= ingredients[x].length) continue;
                if (ingredients[x][y] != null) {
                    prep.add(Character.valueOf(chr));
                    prep.add(InputHelper.toObject((IIngredient)ingredients[x][y]));
                    matrix.append(chr);
                    chr = (char)(chr + '\u0001');
                    continue;
                }
                matrix.append(' ');
            }
            if (matrix.length() <= 0) continue;
            prep.add(y, matrix.toString());
        }
        return prep.toArray();
    }

    public static class RemoveShapeless
    extends BaseUndoable {
        private final IItemStack output;
        private final IIngredient[] ingredients;

        protected RemoveShapeless(IItemStack output, IIngredient[] ingredients) {
            super("Remove Shapeless Anvil");
            this.output = output;
            this.ingredients = ingredients;
        }

        public void apply() {
            if (this.ingredients != null) {
                ShapelessAnvilRecipe removal = new ShapelessAnvilRecipe(new ResourceLocation("crafttweaker", this.name), InputHelper.toStack((IItemStack)this.output), InputHelper.toObjects((IIngredient[])this.ingredients));
                Iterator iterator = AnvilCraftingManager.ANVIL_CRAFTING.iterator();
                while (iterator.hasNext()) {
                    IRecipe recipe = (IRecipe)iterator.next();
                    if (!recipe.func_77571_b().func_77969_a(removal.func_77571_b()) || !removal.func_192400_c().equals((Object)recipe.func_192400_c())) continue;
                    iterator.remove();
                }
            } else {
                Iterator iterator = AnvilCraftingManager.ANVIL_CRAFTING.iterator();
                while (iterator.hasNext()) {
                    IRecipe recipe = (IRecipe)iterator.next();
                    if (!recipe.func_77571_b().func_77969_a(InputHelper.toStack((IItemStack)this.output))) continue;
                    iterator.remove();
                }
            }
        }

        protected String getRecipeInfo() {
            return this.output.getDisplayName();
        }
    }

    public static class RemoveShaped
    extends BaseUndoable {
        private final IItemStack output;
        private final IIngredient[][] ingredients;

        protected RemoveShaped(IItemStack output, IIngredient[][] ingredients) {
            super("Remove Shaped Anvil");
            this.output = output;
            this.ingredients = ingredients;
        }

        public void apply() {
            if (this.ingredients != null) {
                ShapedAnvilRecipe removal = new ShapedAnvilRecipe(new ResourceLocation("crafttweaker", this.name), InputHelper.toStack((IItemStack)this.output), Anvil.toShapedAnvilObjects(this.ingredients));
                Iterator iterator = AnvilCraftingManager.ANVIL_CRAFTING.iterator();
                while (iterator.hasNext()) {
                    IRecipe recipe = (IRecipe)iterator.next();
                    if (!recipe.func_77571_b().func_77969_a(removal.func_77571_b()) || !removal.func_192400_c().equals((Object)recipe.func_192400_c())) continue;
                    iterator.remove();
                }
            } else {
                Iterator iterator = AnvilCraftingManager.ANVIL_CRAFTING.iterator();
                while (iterator.hasNext()) {
                    IRecipe recipe = (IRecipe)iterator.next();
                    if (!recipe.func_77571_b().func_77969_a(InputHelper.toStack((IItemStack)this.output))) continue;
                    iterator.remove();
                }
            }
        }

        protected String getRecipeInfo() {
            return this.output.getDisplayName();
        }
    }

    public static class AddShapeless
    extends BaseUndoable {
        private final IItemStack output;
        private final IIngredient[] ingredients;

        public AddShapeless(IItemStack output, IIngredient[] ingredients) {
            super("Add Anvil Shapeless Recipe");
            this.output = output;
            this.ingredients = ingredients;
        }

        public void apply() {
            AnvilRecipes.addSteelShapelessRecipe((ResourceLocation)new ResourceLocation("crafttweaker", this.name), (ItemStack)InputHelper.toStack((IItemStack)this.output), (Object[])InputHelper.toObjects((IIngredient[])this.ingredients));
        }

        protected String getRecipeInfo() {
            return this.output.getDisplayName();
        }
    }

    public static class AddShaped
    extends BaseUndoable {
        private final IItemStack output;
        private final IIngredient[][] ingredients;

        public AddShaped(IItemStack output, IIngredient[][] ingredients) {
            super("Add Anvil Shaped Recipe");
            this.output = output;
            this.ingredients = ingredients;
        }

        public void apply() {
            AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("crafttweaker", this.name), (ItemStack)InputHelper.toStack((IItemStack)this.output), (Object[])Anvil.toShapedAnvilObjects(this.ingredients));
        }

        protected String getRecipeInfo() {
            return this.output.getDisplayName();
        }
    }
}

