/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePureDaisy;

@ZenClass(value="mods.botania.PureDaisy")
@ModOnly(value="botania")
@ZenRegister
public class PureDaisy {
    public static final String name = "Botania PureDaisy";

    @ZenMethod
    public static void addRecipe(IIngredient blockInput, IItemStack blockOutput) {
        PureDaisy.addRecipe(blockInput, blockOutput, 150);
    }

    @ZenMethod
    public static void addRecipe(IIngredient blockInput, IItemStack blockOutput, int time) {
        if (blockInput == null || blockOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        Object input = InputHelper.toObject((IIngredient)blockInput);
        if (input == null || input instanceof ItemStack && !InputHelper.isABlock((ItemStack)((ItemStack)input))) {
            LogHelper.logError((String)"Input must be a block or an oredict entry.");
            return;
        }
        if (input instanceof ItemStack) {
            input = Block.func_149634_a((Item)((ItemStack)input).func_77973_b());
        }
        ItemStack output = InputHelper.toStack((IItemStack)blockOutput);
        RecipePureDaisy recipe = new RecipePureDaisy(input, Block.func_149634_a((Item)output.func_77973_b()).func_176223_P(), time);
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    private static class Remove
    extends BaseListRemoval<RecipePureDaisy> {
        final IIngredient output;

        public Remove(IIngredient output) {
            super(PureDaisy.name, BotaniaAPI.pureDaisyRecipes, Collections.emptyList());
            this.output = output;
        }

        protected String getRecipeInfo(RecipePureDaisy recipe) {
            return LogHelper.getStackDescription((Object)new ItemStack(recipe.getOutputState().func_177230_c(), 1));
        }

        public void apply() {
            LinkedList<RecipePureDaisy> recipes = new LinkedList<RecipePureDaisy>();
            for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes) {
                IItemStack out = InputHelper.toIItemStack((ItemStack)new ItemStack(recipe.getOutputState().func_177230_c(), 1));
                if (!StackHelper.matches((IIngredient)this.output, (IItemStack)out)) continue;
                recipes.add(recipe);
            }
            if (!recipes.isEmpty()) {
                this.recipes.addAll(recipes);
                super.apply();
            } else {
                LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", PureDaisy.name, this.output.toString()));
            }
            CraftTweakerAPI.getLogger().logInfo(super.describe());
        }

        public String describe() {
            return "Attempting to remove Pure Daisy recipe for " + this.output.getItems();
        }
    }

    private static class Add
    extends BaseListAddition<RecipePureDaisy> {
        public Add(RecipePureDaisy recipe) {
            super(PureDaisy.name, BotaniaAPI.pureDaisyRecipes, Collections.singletonList(recipe));
        }

        protected String getRecipeInfo(RecipePureDaisy recipe) {
            return LogHelper.getStackDescription((Object)new ItemStack(recipe.getOutputState().func_177230_c(), 1));
        }
    }
}

