/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tcomplement;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.MeltingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.LinkedHashMap;
import java.util.Map;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tcomplement.Overrides")
@ZenRegister
@ModOnly(value="tcomplement")
public class Overrides {
    public static final Map<ILiquidStack, IItemStack> REMOVED_RECIPES = new LinkedHashMap<ILiquidStack, IItemStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Overrides());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack output, IItemStack input, @Optional int temp) {
        Overrides.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toStack((IItemStack)input), temp));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output, @Optional IItemStack input) {
        Overrides.init();
        CraftTweakerAPI.apply((IAction)new Remove(output, input));
    }

    @SubscribeEvent
    public void onTinkerRegister(TCompRegisterEvent.MelterOverrideRegisterEvent event) {
        if (event.getRecipe() instanceof MeltingRecipeTweaker) {
            return;
        }
        for (Map.Entry<ILiquidStack, IItemStack> ent : REMOVED_RECIPES.entrySet()) {
            if (!((MeltingRecipe)event.getRecipe()).getResult().isFluidEqual((FluidStack)ent.getKey().getInternal())) continue;
            if (ent.getValue() != null) {
                if (!((MeltingRecipe)event.getRecipe()).input.matches(NonNullList.func_191197_a((int)1, (Object)((ItemStack)ent.getValue().getInternal()))).isPresent()) continue;
                event.setCanceled(true);
                continue;
            }
            event.setCanceled(true);
        }
    }

    private static class Remove
    extends BaseUndoable {
        private ILiquidStack output;
        private IItemStack input;

        protected Remove(ILiquidStack output, IItemStack input) {
            super("Overrides");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            REMOVED_RECIPES.put(this.output, this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class Add
    extends BaseUndoable {
        private FluidStack output;
        private ItemStack input;
        private int temp;

        public Add(FluidStack output, ItemStack input, int temp) {
            super("Overrides");
            this.output = output;
            this.input = input;
            this.temp = temp;
        }

        public void apply() {
            if (this.temp != 0) {
                TCompRegistry.registerMelterOverride((MeltingRecipe)new MeltingRecipeTweaker(RecipeMatch.of((ItemStack)this.input, (int)this.output.amount), this.output, this.temp));
            } else {
                TCompRegistry.registerMelterOverride((MeltingRecipe)new MeltingRecipeTweaker(RecipeMatch.of((ItemStack)this.input, (int)this.output.amount), this.output));
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

