/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.AlloyRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Alloy")
@ZenRegister
@ModOnly(value="tconstruct")
public class Alloy {
    public static final Map<ILiquidStack, List<ILiquidStack>> REMOVED_RECIPES = new LinkedHashMap<ILiquidStack, List<ILiquidStack>>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Alloy());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack[] inputs) {
        Alloy.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toFluids((ILiquidStack[])inputs)));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output, @Optional ILiquidStack[] input) {
        Alloy.init();
        ArrayList<ILiquidStack> in = new ArrayList<ILiquidStack>();
        if (input == null || input.length == 0) {
            in = null;
        } else {
            Collections.addAll(in, input);
        }
        CraftTweakerAPI.apply((IAction)new Remove(output, in));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.AlloyRegisterEvent event) {
        if (event.getRecipe() instanceof AlloyRecipeTweaker) {
            return;
        }
        for (Map.Entry<ILiquidStack, List<ILiquidStack>> entry : REMOVED_RECIPES.entrySet()) {
            if (!((AlloyRecipe)event.getRecipe()).getResult().isFluidEqual((FluidStack)entry.getKey().getInternal())) continue;
            if (entry.getValue() != null) {
                List<ILiquidStack> in = entry.getValue();
                List rin = ((AlloyRecipe)event.getRecipe()).getFluids();
                if (rin.size() != in.size()) continue;
                boolean valid = true;
                for (int i = 0; i < in.size(); ++i) {
                    ILiquidStack stack = in.get(i);
                    FluidStack lStack = (FluidStack)rin.get(i);
                    if (lStack.isFluidEqual((FluidStack)stack.getInternal())) continue;
                    valid = false;
                }
                if (!valid) continue;
                event.setCanceled(true);
                continue;
            }
            event.setCanceled(true);
        }
    }

    private static class Remove
    extends BaseUndoable {
        private ILiquidStack output;
        private List<ILiquidStack> inputs;

        protected Remove(ILiquidStack output) {
            super("Alloy");
            this.output = output;
        }

        protected Remove(ILiquidStack output, List<ILiquidStack> inputs) {
            super("Alloy");
            this.output = output;
            this.inputs = inputs;
        }

        public void apply() {
            REMOVED_RECIPES.put(this.output, this.inputs);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class Add
    extends BaseUndoable {
        private FluidStack output;
        private FluidStack[] input;

        public Add(FluidStack output, FluidStack[] input) {
            super("Alloy");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            TinkerRegistry.registerAlloy((AlloyRecipe)new AlloyRecipeTweaker(this.output, this.input));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

