/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.CastingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Casting")
@ZenRegister
@ModOnly(value="tconstruct")
public class Casting {
    public static final Map<IItemStack, ILiquidStack> REMOVED_RECIPES_TABLE = new LinkedHashMap<IItemStack, ILiquidStack>();
    public static final Map<IItemStack, ILiquidStack> REMOVED_RECIPES_BASIN = new LinkedHashMap<IItemStack, ILiquidStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Casting());
            init = true;
        }
    }

    @ZenMethod
    public static void addTableRecipe(IItemStack output, IItemStack cast, ILiquidStack fluid, int amount, @Optional boolean consumeCast) {
        Casting.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), InputHelper.toStack((IItemStack)cast), InputHelper.toFluid((ILiquidStack)fluid), amount, true, consumeCast));
    }

    @ZenMethod
    public static void addBasinRecipe(IItemStack output, IItemStack cast, ILiquidStack fluid, int amount, @Optional boolean consumeCast) {
        Casting.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), InputHelper.toStack((IItemStack)cast), InputHelper.toFluid((ILiquidStack)fluid), amount, false, consumeCast));
    }

    @ZenMethod
    public static void removeTableRecipe(IItemStack output, @Optional ILiquidStack input) {
        Casting.init();
        CraftTweakerAPI.apply((IAction)new Remove(output, input, true));
    }

    @ZenMethod
    public static void removeBasinRecipe(IItemStack output, @Optional ILiquidStack input) {
        Casting.init();
        CraftTweakerAPI.apply((IAction)new Remove(output, input, false));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.TableCastingRegisterEvent event) {
        if (event.getRecipe() instanceof CastingRecipeTweaker || !(event.getRecipe() instanceof CastingRecipe)) {
            return;
        }
        for (Map.Entry<IItemStack, ILiquidStack> ent : REMOVED_RECIPES_TABLE.entrySet()) {
            IItemStack stack = ent.getKey();
            if (stack == null || ((CastingRecipe)event.getRecipe()).getResult() == null) continue;
            if (ent.getValue() == null) {
                if (!stack.matches(InputHelper.toIItemStack((ItemStack)((CastingRecipe)event.getRecipe()).getResult()))) continue;
                event.setCanceled(true);
                continue;
            }
            if (!stack.matches(InputHelper.toIItemStack((ItemStack)((CastingRecipe)event.getRecipe()).getResult())) || !((CastingRecipe)event.getRecipe()).getFluid().isFluidEqual((FluidStack)ent.getValue().getInternal())) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.BasinCastingRegisterEvent event) {
        if (event.getRecipe() instanceof CastingRecipeTweaker || !(event.getRecipe() instanceof CastingRecipe)) {
            return;
        }
        for (Map.Entry<IItemStack, ILiquidStack> ent : REMOVED_RECIPES_BASIN.entrySet()) {
            IItemStack stack = ent.getKey();
            if (stack == null || ((CastingRecipe)event.getRecipe()).getResult() == null || !stack.matches(InputHelper.toIItemStack((ItemStack)((CastingRecipe)event.getRecipe()).getResult()))) continue;
            if (ent.getValue() != null) {
                if (!((CastingRecipe)event.getRecipe()).getFluid().isFluidEqual((FluidStack)ent.getValue().getInternal())) continue;
                event.setCanceled(true);
                continue;
            }
            event.setCanceled(true);
        }
    }

    private static class Add
    extends BaseUndoable {
        private ItemStack output;
        private ItemStack cast;
        private FluidStack fluid;
        private int amount;
        private boolean table;
        private boolean consumeCast;

        public Add(ItemStack output, ItemStack cast, FluidStack fluid, int amount, boolean table, boolean consumeCast) {
            super("Casting");
            this.output = output;
            this.cast = cast;
            this.fluid = fluid;
            this.amount = amount;
            this.table = table;
            this.consumeCast = consumeCast;
        }

        public void apply() {
            RecipeMatch rm = null;
            if (this.cast != ItemStack.field_190927_a) {
                rm = RecipeMatch.ofNBT((ItemStack)this.cast);
            }
            if (this.table) {
                TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipeTweaker(this.output, rm, this.fluid.getFluid(), this.amount, this.consumeCast, false));
            } else {
                TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipeTweaker(this.output, rm, this.fluid.getFluid(), this.amount, this.consumeCast, false));
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }

    private static class Remove
    extends BaseUndoable {
        private IItemStack output;
        private ILiquidStack input;
        private boolean table;

        protected Remove(IItemStack output, ILiquidStack input, boolean table) {
            super("Casting");
            this.output = output;
            this.input = input;
            this.table = table;
        }

        public void apply() {
            if (this.table) {
                REMOVED_RECIPES_TABLE.put(this.output, this.input);
            } else {
                REMOVED_RECIPES_BASIN.put(this.output, this.input);
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }
}

