/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Centrifuge")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class Centrifuge {
    @ZenMethod
    public static void addRecipe(WeightedItemStack[] outputs, IItemStack input, ILiquidStack fluid, int energy) {
        IItemStack[] items = new IItemStack[outputs.length];
        Integer[] chances = new Integer[outputs.length];
        for (int i = 0; i < outputs.length; ++i) {
            items[i] = outputs[i].getStack();
            chances[i] = (int)outputs[i].getPercent();
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStacks((IItemStack[])items), chances, InputHelper.toStack((IItemStack)input), energy, InputHelper.toFluid((ILiquidStack)fluid)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)input)));
    }

    private static class Remove
    extends BaseUndoable {
        private ItemStack input;

        public Remove(ItemStack input) {
            super("Centrifuge");
            this.input = input;
        }

        public void apply() {
            if (!CentrifugeManager.recipeExists((ItemStack)this.input)) {
                CraftTweakerAPI.logError((String)("No Centrifuge recipe exists for: " + this.input));
                return;
            }
            CentrifugeManager.removeRecipe((ItemStack)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }

    private static class Add
    extends BaseUndoable {
        private ItemStack[] outputs;
        private Integer[] chances;
        private ItemStack input;
        private int energy;
        private FluidStack fluid;

        public Add(ItemStack[] outputs, Integer[] chances, ItemStack input, int energy, FluidStack fluid) {
            super("Centrifuge");
            this.outputs = outputs;
            this.chances = chances;
            this.input = input;
            this.energy = energy;
            this.fluid = fluid;
        }

        public void apply() {
            CentrifugeManager.addRecipe((int)this.energy, (ItemStack)this.input, Arrays.asList(this.outputs), Arrays.asList(this.chances), (FluidStack)this.fluid);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }
}

